/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.proxy.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.BaseEncoding;
import io.atomix.primitive.PrimitiveState;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.Partitioner;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.primitive.proxy.ProxySession;
import io.atomix.primitive.proxy.impl.DefaultProxySession;
import io.atomix.primitive.session.SessionClient;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class DefaultProxyClient<S>
implements ProxyClient<S> {
    private final String name;
    private final PrimitiveType type;
    private final PrimitiveProtocol protocol;
    private final Serializer serializer;
    private final List<PartitionId> partitionIds = new CopyOnWriteArrayList<PartitionId>();
    private final Map<PartitionId, ProxySession<S>> partitions = Maps.newConcurrentMap();
    private final Partitioner<String> partitioner;
    private final Set<Consumer<PrimitiveState>> stateChangeListeners = Sets.newCopyOnWriteArraySet();
    private final Map<PartitionId, PrimitiveState> states = Maps.newHashMap();
    private volatile PrimitiveState state = PrimitiveState.CLOSED;

    public DefaultProxyClient(String name, PrimitiveType type, PrimitiveProtocol protocol, Class<S> serviceType, Collection<SessionClient> partitions, Partitioner<String> partitioner) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        this.type = (PrimitiveType)Preconditions.checkNotNull((Object)type, (Object)"type cannot be null");
        this.protocol = (PrimitiveProtocol)Preconditions.checkNotNull((Object)protocol, (Object)"protocol cannot be null");
        this.serializer = Serializer.using((Namespace)type.namespace());
        this.partitioner = (Partitioner)Preconditions.checkNotNull(partitioner, (Object)"partitioner cannot be null");
        partitions.forEach(partition -> {
            this.partitionIds.add(partition.partitionId());
            this.partitions.put(partition.partitionId(), new DefaultProxySession((SessionClient)partition, serviceType, this.serializer));
            this.states.put(partition.partitionId(), PrimitiveState.CLOSED);
            partition.addStateChangeListener(state -> this.onStateChange(partition.partitionId(), (PrimitiveState)((Object)((Object)state))));
        });
        Collections.sort(this.partitionIds);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public PrimitiveType type() {
        return this.type;
    }

    @Override
    public PrimitiveProtocol protocol() {
        return this.protocol;
    }

    @Override
    public PrimitiveState getState() {
        return this.state;
    }

    @Override
    public Collection<ProxySession<S>> getPartitions() {
        return this.partitions.values();
    }

    @Override
    public Collection<PartitionId> getPartitionIds() {
        return this.partitions.keySet();
    }

    @Override
    public ProxySession<S> getPartition(PartitionId partitionId) {
        return this.partitions.get(partitionId);
    }

    @Override
    public PartitionId getPartitionId(String key) {
        return this.partitioner.partition(key, this.partitionIds);
    }

    @Override
    public PartitionId getPartitionId(Object key) {
        return this.partitioner.partition(BaseEncoding.base16().encode(this.serializer.encode(key)), this.partitionIds);
    }

    @Override
    public void addStateChangeListener(Consumer<PrimitiveState> listener) {
        this.stateChangeListeners.add(listener);
    }

    @Override
    public void removeStateChangeListener(Consumer<PrimitiveState> listener) {
        this.stateChangeListeners.remove(listener);
    }

    @Override
    public CompletableFuture<ProxyClient<S>> connect() {
        this.partitions.forEach((partitionId, partition) -> partition.addStateChangeListener(state -> this.onStateChange((PartitionId)partitionId, (PrimitiveState)((Object)((Object)state)))));
        return Futures.allOf(this.partitions.values().stream().map(ProxySession::connect).collect(Collectors.toList())).thenApply(v -> this);
    }

    @Override
    public CompletableFuture<Void> delete() {
        return Futures.allOf(this.partitions.values().stream().map(ProxySession::delete).collect(Collectors.toList())).thenApply(v -> null);
    }

    @Override
    public CompletableFuture<Void> close() {
        return Futures.allOf(this.partitions.values().stream().map(ProxySession::close).collect(Collectors.toList())).thenApply(v -> null);
    }

    private synchronized void onStateChange(PartitionId partitionId, PrimitiveState state) {
        this.states.put(partitionId, state);
        switch (state) {
            case CONNECTED: {
                if (this.state == PrimitiveState.CONNECTED || this.states.containsValue((Object)PrimitiveState.SUSPENDED) || this.states.containsValue((Object)PrimitiveState.CLOSED)) break;
                this.state = PrimitiveState.CONNECTED;
                this.stateChangeListeners.forEach(l -> l.accept(PrimitiveState.CONNECTED));
                break;
            }
            case SUSPENDED: {
                if (this.state != PrimitiveState.CONNECTED) break;
                this.state = PrimitiveState.SUSPENDED;
                this.stateChangeListeners.forEach(l -> l.accept(PrimitiveState.SUSPENDED));
                break;
            }
            case CLOSED: {
                if (this.state == PrimitiveState.CLOSED) break;
                this.state = PrimitiveState.CLOSED;
                this.stateChangeListeners.forEach(l -> l.accept(PrimitiveState.CLOSED));
            }
        }
    }
}

