/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import io.atomix.primitive.PrimitiveManagementService;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.SyncPrimitive;
import io.atomix.primitive.config.PrimitiveConfig;
import io.atomix.primitive.partition.PartitionGroup;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.PrimitiveProtocolConfig;
import io.atomix.primitive.protocol.ProxyProtocol;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.primitive.service.ServiceConfig;
import io.atomix.utils.Builder;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.config.ConfigurationException;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.NamespaceConfig;
import io.atomix.utils.serializer.Namespaces;
import io.atomix.utils.serializer.Serializer;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public abstract class PrimitiveBuilder<B extends PrimitiveBuilder<B, C, P>, C extends PrimitiveConfig, P extends SyncPrimitive>
implements Builder<P> {
    protected final PrimitiveType type;
    protected final String name;
    protected final C config;
    protected PrimitiveProtocol protocol;
    protected Serializer serializer;
    protected final PrimitiveManagementService managementService;

    public PrimitiveBuilder(PrimitiveType type, String name, C config, PrimitiveManagementService managementService) {
        this.type = (PrimitiveType)Preconditions.checkNotNull((Object)type, (Object)"type cannot be null");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        this.config = (PrimitiveConfig)Preconditions.checkNotNull(config, (Object)"config cannot be null");
        this.managementService = (PrimitiveManagementService)Preconditions.checkNotNull((Object)managementService, (Object)"managementService cannot be null");
    }

    protected B withProtocol(PrimitiveProtocol protocol) {
        this.protocol = protocol;
        return (B)this;
    }

    public B withSerializer(Serializer serializer) {
        this.serializer = (Serializer)Preconditions.checkNotNull((Object)serializer);
        return (B)this;
    }

    public B withReadOnly() {
        ((PrimitiveConfig)this.config).setReadOnly();
        return (B)this;
    }

    public B withReadOnly(boolean readOnly) {
        ((PrimitiveConfig)this.config).setReadOnly(readOnly);
        return (B)this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected PrimitiveProtocol protocol() {
        PrimitiveProtocol protocol = this.protocol;
        if (protocol != null) return protocol;
        PrimitiveProtocolConfig protocolConfig = ((PrimitiveConfig)this.config).getProtocolConfig();
        if (protocolConfig != null) return ((PrimitiveProtocol.Type)protocolConfig.getType()).newProtocol(protocolConfig);
        Collection<PartitionGroup> partitionGroups = this.managementService.getPartitionService().getPartitionGroups();
        if (partitionGroups.size() == 1) {
            return partitionGroups.iterator().next().newProtocol();
        }
        String groups = Joiner.on((String)", ").join((Iterable)partitionGroups.stream().map(group -> group.name()).collect(Collectors.toList()));
        throw new ConfigurationException(String.format("Primitive protocol is ambiguous: %d partition groups found (%s)", partitionGroups.size(), groups));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Serializer serializer() {
        Serializer serializer = this.serializer;
        if (serializer == null) {
            PrimitiveBuilder primitiveBuilder = this;
            synchronized (primitiveBuilder) {
                serializer = this.serializer;
                if (serializer == null) {
                    NamespaceConfig config = ((PrimitiveConfig)this.config).getNamespaceConfig();
                    serializer = config == null ? Serializer.using((Namespace)Namespaces.BASIC) : Serializer.using((Namespace)Namespace.builder().register(Namespaces.BASIC).nextId(500).register(new Namespace(config)).build());
                    this.serializer = serializer;
                }
            }
        }
        return serializer;
    }

    protected <S> CompletableFuture<ProxyClient<S>> newProxy(Class<S> serviceType, ServiceConfig config) {
        PrimitiveProtocol protocol = this.protocol();
        if (protocol instanceof ProxyProtocol) {
            return CompletableFuture.completedFuture(((ProxyProtocol)protocol).newProxy(this.name, this.type, serviceType, config, this.managementService.getPartitionService()));
        }
        return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
    }

    public P build() {
        return (P)((SyncPrimitive)this.buildAsync().join());
    }

    public abstract CompletableFuture<P> buildAsync();
}

