/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.session;

import io.atomix.cluster.NodeId;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.event.EventType;
import io.atomix.primitive.event.PrimitiveEvent;
import io.atomix.primitive.session.SessionEventListener;
import io.atomix.primitive.session.SessionId;
import io.atomix.storage.buffer.HeapBytes;
import java.util.function.Function;

public interface Session {
    public SessionId sessionId();

    public String serviceName();

    public PrimitiveType serviceType();

    public NodeId nodeId();

    public State getState();

    public void addListener(SessionEventListener var1);

    public void removeListener(SessionEventListener var1);

    default public void publish(EventType eventType) {
        this.publish(eventType, HeapBytes.EMPTY);
    }

    default public <T> void publish(EventType eventType, Function<T, byte[]> encoder, T event) {
        this.publish(eventType, encoder.apply(event));
    }

    default public void publish(EventType eventType, byte[] event) {
        this.publish(new PrimitiveEvent(EventType.simplify(eventType), event));
    }

    public void publish(PrimitiveEvent var1);

    public static enum State {
        OPEN(true),
        SUSPICIOUS(true),
        EXPIRED(false),
        CLOSED(false);

        private final boolean active;

        private State(boolean active) {
            this.active = active;
        }

        public boolean active() {
            return this.active;
        }
    }
}

