/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.proxy.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.event.PrimitiveEvent;
import io.atomix.primitive.operation.PrimitiveOperation;
import io.atomix.primitive.proxy.PrimitiveProxy;
import io.atomix.primitive.proxy.impl.AbstractPrimitiveProxy;
import io.atomix.primitive.session.SessionId;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.concurrent.OrderedFuture;
import io.atomix.utils.concurrent.Scheduled;
import io.atomix.utils.concurrent.Scheduler;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class RecoveringPrimitiveProxy
extends AbstractPrimitiveProxy {
    private static final SessionId DEFAULT_SESSION_ID = SessionId.from(0L);
    private final String name;
    private final PrimitiveType primitiveType;
    private final Supplier<PrimitiveProxy> proxyFactory;
    private final Scheduler scheduler;
    private Logger log;
    private volatile OrderedFuture<PrimitiveProxy> clientFuture;
    private volatile PrimitiveProxy proxy;
    private volatile PrimitiveProxy.State state = PrimitiveProxy.State.SUSPENDED;
    private final Set<Consumer<PrimitiveProxy.State>> stateChangeListeners = Sets.newCopyOnWriteArraySet();
    private final Set<Consumer<PrimitiveEvent>> eventListeners = Sets.newCopyOnWriteArraySet();
    private Scheduled recoverTask;
    private volatile boolean connected = false;

    public RecoveringPrimitiveProxy(String clientId, String name, PrimitiveType primitiveType, Supplier<PrimitiveProxy> proxyFactory, Scheduler scheduler) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.primitiveType = (PrimitiveType)Preconditions.checkNotNull((Object)primitiveType);
        this.proxyFactory = (Supplier)Preconditions.checkNotNull(proxyFactory);
        this.scheduler = (Scheduler)Preconditions.checkNotNull((Object)scheduler);
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(PrimitiveProxy.class).addValue((Object)clientId).build());
    }

    @Override
    public SessionId sessionId() {
        PrimitiveProxy proxy = this.proxy;
        return proxy != null ? proxy.sessionId() : DEFAULT_SESSION_ID;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public PrimitiveType serviceType() {
        return this.primitiveType;
    }

    @Override
    public PrimitiveProxy.State getState() {
        return this.state;
    }

    private synchronized void onStateChange(PrimitiveProxy.State state) {
        if (this.state != state) {
            if (state == PrimitiveProxy.State.CLOSED) {
                if (this.connected) {
                    this.onStateChange(PrimitiveProxy.State.SUSPENDED);
                    this.recover();
                } else {
                    this.log.debug("State changed: {}", (Object)state);
                    this.state = state;
                    this.stateChangeListeners.forEach(l -> l.accept(state));
                }
            } else {
                this.log.debug("State changed: {}", (Object)state);
                this.state = state;
                this.stateChangeListeners.forEach(l -> l.accept(state));
            }
        }
    }

    @Override
    public void addStateChangeListener(Consumer<PrimitiveProxy.State> listener) {
        this.stateChangeListeners.add(listener);
    }

    @Override
    public void removeStateChangeListener(Consumer<PrimitiveProxy.State> listener) {
        this.stateChangeListeners.remove(listener);
    }

    private void checkOpen() {
        Preconditions.checkState((boolean)this.connected, (Object)"client not open");
    }

    private void recover() {
        this.proxy = null;
        this.openProxy();
    }

    private CompletableFuture<PrimitiveProxy> openProxy() {
        if (this.connected) {
            this.log.debug("Opening proxy session");
            this.clientFuture = new OrderedFuture();
            this.openProxy((CompletableFuture<PrimitiveProxy>)this.clientFuture);
            return this.clientFuture.thenApply(client -> {
                RecoveringPrimitiveProxy recoveringPrimitiveProxy = this;
                synchronized (recoveringPrimitiveProxy) {
                    this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(PrimitiveProxy.class).addValue((Object)client.sessionId()).add("type", (Object)client.serviceType()).add("name", (Object)client.name()).build());
                    this.proxy = client;
                    client.addStateChangeListener(this::onStateChange);
                    this.eventListeners.forEach(client::addEventListener);
                    this.onStateChange(PrimitiveProxy.State.CONNECTED);
                }
                return client;
            });
        }
        return Futures.exceptionalFuture((Throwable)new IllegalStateException("Client not open"));
    }

    private void openProxy(CompletableFuture<PrimitiveProxy> future) {
        this.proxyFactory.get().connect().whenComplete((proxy, error) -> {
            if (error == null) {
                future.complete((PrimitiveProxy)proxy);
            } else {
                this.recoverTask = this.scheduler.schedule(Duration.ofSeconds(1L), () -> this.openProxy(future));
            }
        });
    }

    @Override
    public CompletableFuture<byte[]> execute(PrimitiveOperation operation) {
        this.checkOpen();
        PrimitiveProxy proxy = this.proxy;
        if (proxy != null) {
            return proxy.execute(operation);
        }
        return this.clientFuture.thenCompose(c -> c.execute(operation));
    }

    @Override
    public synchronized void addEventListener(Consumer<PrimitiveEvent> consumer) {
        this.checkOpen();
        this.eventListeners.add(consumer);
        PrimitiveProxy proxy = this.proxy;
        if (proxy != null) {
            proxy.addEventListener(consumer);
        }
    }

    @Override
    public synchronized void removeEventListener(Consumer<PrimitiveEvent> consumer) {
        this.checkOpen();
        this.eventListeners.remove(consumer);
        PrimitiveProxy proxy = this.proxy;
        if (proxy != null) {
            proxy.removeEventListener(consumer);
        }
    }

    @Override
    public synchronized CompletableFuture<PrimitiveProxy> connect() {
        if (!this.connected) {
            this.connected = true;
            return this.openProxy().thenApply(c -> this);
        }
        return CompletableFuture.completedFuture(this);
    }

    @Override
    public synchronized CompletableFuture<Void> close() {
        if (this.connected) {
            PrimitiveProxy proxy;
            this.connected = false;
            if (this.recoverTask != null) {
                this.recoverTask.cancel();
            }
            if ((proxy = this.proxy) != null) {
                return proxy.close();
            }
            return this.clientFuture.thenCompose(c -> c.close());
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.proxy.name()).add("serviceType", (Object)this.proxy.serviceType()).add("state", (Object)this.state).toString();
    }
}

