/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.partition;

import com.google.common.base.MoreObjects;
import io.atomix.primitive.partition.Member;
import io.atomix.primitive.partition.MemberGroupId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class PrimaryTerm {
    private final long term;
    private final Member primary;
    private final List<Member> candidates;

    public PrimaryTerm(long term, Member primary, List<Member> candidates) {
        this.term = term;
        this.primary = primary;
        this.candidates = candidates;
    }

    public long term() {
        return this.term;
    }

    public Member primary() {
        return this.primary;
    }

    public List<Member> candidates() {
        return this.candidates;
    }

    public List<Member> backups(int numBackups) {
        int j;
        if (this.primary == null) {
            return Collections.emptyList();
        }
        ArrayList<Member> backups = new ArrayList<Member>();
        HashSet<MemberGroupId> groups = new HashSet<MemberGroupId>();
        groups.add(this.primary.groupId());
        int i = 0;
        block0: for (j = 0; j < numBackups; ++j) {
            while (i < this.candidates.size()) {
                Member member;
                if (!groups.add((member = this.candidates.get(i++)).groupId())) continue;
                backups.add(member);
                continue block0;
            }
        }
        block2: for (j = backups.size(); j < numBackups; ++j) {
            for (Member candidate : this.candidates) {
                if (candidate.equals(this.primary) || backups.contains(candidate)) continue;
                backups.add(candidate);
                continue block2;
            }
        }
        return backups;
    }

    public int hashCode() {
        return Objects.hash(this.term, this.primary, this.candidates);
    }

    public boolean equals(Object object) {
        if (object instanceof PrimaryTerm) {
            PrimaryTerm term = (PrimaryTerm)object;
            return term.term == this.term && Objects.equals(term.primary, this.primary) && Objects.equals(term.candidates, this.candidates);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("term", this.term).add("primary", (Object)this.primary).add("candidates", this.candidates).toString();
    }
}

