/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.partition;

import io.atomix.cluster.Node;
import io.atomix.primitive.partition.MemberGroup;
import io.atomix.primitive.partition.MemberGroupId;
import io.atomix.primitive.partition.MemberGroupProvider;
import io.atomix.primitive.partition.impl.NodeMemberGroup;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum MemberGroupStrategy implements MemberGroupProvider
{
    ZONE_AWARE{

        @Override
        public Collection<MemberGroup> getMemberGroups(Collection<Node> nodes) {
            return this.groupNodes(nodes, Node::zone);
        }
    }
    ,
    RACK_AWARE{

        @Override
        public Collection<MemberGroup> getMemberGroups(Collection<Node> nodes) {
            return this.groupNodes(nodes, Node::rack);
        }
    }
    ,
    HOST_AWARE{

        @Override
        public Collection<MemberGroup> getMemberGroups(Collection<Node> nodes) {
            return this.groupNodes(nodes, Node::host);
        }
    }
    ,
    NODE_AWARE{

        @Override
        public Collection<MemberGroup> getMemberGroups(Collection<Node> nodes) {
            return this.groupNodes(nodes, node -> (String)((Object)node.id().id()));
        }
    };


    protected Collection<MemberGroup> groupNodes(Collection<Node> nodes, Function<Node, String> keyFunction) {
        HashMap<String, Set> groups = new HashMap<String, Set>();
        for (Node node : nodes) {
            groups.computeIfAbsent(keyFunction.apply(node), k -> new HashSet()).add(node);
        }
        return groups.entrySet().stream().map(entry -> new NodeMemberGroup(MemberGroupId.from((String)entry.getKey()), (Set)entry.getValue())).collect(Collectors.toList());
    }
}

