/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.proxy.impl;

import com.google.common.base.Throwables;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.operation.PrimitiveOperation;
import io.atomix.primitive.proxy.PrimitiveProxy;
import io.atomix.primitive.proxy.impl.DelegatingPrimitiveProxy;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.concurrent.Scheduler;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import java.net.ConnectException;
import java.nio.channels.ClosedChannelException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.slf4j.Logger;

public class RetryingPrimitiveProxy
extends DelegatingPrimitiveProxy {
    private final Logger log;
    private final PrimitiveProxy proxy;
    private final Scheduler scheduler;
    private final int maxRetries;
    private final Duration delayBetweenRetries;
    private final Predicate<Throwable> retryableCheck = e -> e instanceof ConnectException || e instanceof TimeoutException || e instanceof ClosedChannelException || e instanceof PrimitiveException.Unavailable || e instanceof PrimitiveException.Timeout || e instanceof PrimitiveException.QueryFailure || e instanceof PrimitiveException.UnknownClient || e instanceof PrimitiveException.UnknownSession || e instanceof PrimitiveException.ClosedSession;

    public RetryingPrimitiveProxy(PrimitiveProxy delegate, Scheduler scheduler, int maxRetries, Duration delayBetweenRetries) {
        super(delegate);
        this.proxy = delegate;
        this.scheduler = scheduler;
        this.maxRetries = maxRetries;
        this.delayBetweenRetries = delayBetweenRetries;
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(PrimitiveProxy.class).addValue((Object)this.proxy.sessionId()).add("type", (Object)this.proxy.serviceType()).add("name", (Object)this.proxy.name()).build());
    }

    @Override
    public CompletableFuture<byte[]> execute(PrimitiveOperation operation) {
        if (this.getState() == PrimitiveProxy.State.CLOSED) {
            return Futures.exceptionalFuture((Throwable)((Object)new PrimitiveException.Unavailable()));
        }
        CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
        this.execute(operation, 1, future);
        return future;
    }

    private void execute(PrimitiveOperation operation, int attemptIndex, CompletableFuture<byte[]> future) {
        this.proxy.execute(operation).whenComplete((r, e) -> {
            if (e != null) {
                if (attemptIndex < this.maxRetries + 1 && this.retryableCheck.test(Throwables.getRootCause((Throwable)e))) {
                    this.log.debug("Retry attempt ({} of {}). Failure due to {}", new Object[]{attemptIndex, this.maxRetries, Throwables.getRootCause((Throwable)e).getClass()});
                    this.scheduleRetry(operation, attemptIndex, future);
                } else {
                    future.completeExceptionally((Throwable)e);
                }
            } else {
                future.complete((byte[])r);
            }
        });
    }

    private void scheduleRetry(PrimitiveOperation operation, int attemptIndex, CompletableFuture<byte[]> future) {
        PrimitiveProxy.State retryState = this.proxy.getState();
        this.scheduler.schedule(this.delayBetweenRetries.multipliedBy(2 ^ attemptIndex), () -> {
            if (retryState == PrimitiveProxy.State.CONNECTED || this.proxy.getState() == PrimitiveProxy.State.CONNECTED) {
                this.execute(operation, attemptIndex + 1, future);
            } else {
                this.scheduleRetry(operation, attemptIndex, future);
            }
        });
    }
}

