/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.service;

import io.atomix.primitive.PrimitiveId;
import io.atomix.primitive.service.Commit;
import io.atomix.primitive.service.PrimitiveService;
import io.atomix.primitive.service.ServiceContext;
import io.atomix.primitive.service.ServiceExecutor;
import io.atomix.primitive.service.impl.DefaultServiceExecutor;
import io.atomix.primitive.session.Session;
import io.atomix.primitive.session.Sessions;
import io.atomix.utils.concurrent.Scheduler;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import io.atomix.utils.time.Clock;
import io.atomix.utils.time.LogicalClock;
import io.atomix.utils.time.WallClock;
import io.atomix.utils.time.WallClockTimestamp;
import org.slf4j.Logger;

public abstract class AbstractPrimitiveService
implements PrimitiveService {
    private Logger log;
    private ServiceContext context;
    private ServiceExecutor executor;

    @Override
    public void init(ServiceContext context) {
        this.context = context;
        this.executor = new DefaultServiceExecutor(context);
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(PrimitiveService.class).addValue((Object)context.serviceId()).add("type", (Object)context.serviceType()).add("name", (Object)context.serviceName()).build());
        this.configure(this.executor);
    }

    @Override
    public void tick(WallClockTimestamp timestamp) {
        this.executor.tick(timestamp);
    }

    @Override
    public byte[] apply(Commit<byte[]> commit) {
        return this.executor.apply(commit);
    }

    protected abstract void configure(ServiceExecutor var1);

    protected Logger getLogger() {
        return this.log;
    }

    protected Scheduler getScheduler() {
        return this.executor;
    }

    protected PrimitiveId getServiceId() {
        return this.context.serviceId();
    }

    protected String getServiceName() {
        return this.context.serviceName();
    }

    protected long getCurrentIndex() {
        return this.context.currentIndex();
    }

    protected Session getCurrentSession() {
        return this.context.currentSession();
    }

    protected Clock getClock() {
        return this.getWallClock();
    }

    protected WallClock getWallClock() {
        return this.context.wallClock();
    }

    protected LogicalClock getLogicalClock() {
        return this.context.logicalClock();
    }

    protected Sessions getSessions() {
        return this.context.sessions();
    }

    @Override
    public void onOpen(Session session) {
    }

    @Override
    public void onExpire(Session session) {
    }

    @Override
    public void onClose(Session session) {
    }
}

