/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup.roles;

import com.google.common.base.MoreObjects;
import io.atomix.protocols.backup.PrimaryBackupServer;
import io.atomix.protocols.backup.impl.PrimaryBackupSession;
import io.atomix.protocols.backup.protocol.BackupRequest;
import io.atomix.protocols.backup.protocol.BackupResponse;
import io.atomix.protocols.backup.protocol.ExecuteRequest;
import io.atomix.protocols.backup.protocol.ExecuteResponse;
import io.atomix.protocols.backup.protocol.PrimaryBackupRequest;
import io.atomix.protocols.backup.protocol.PrimaryBackupResponse;
import io.atomix.protocols.backup.protocol.RestoreRequest;
import io.atomix.protocols.backup.protocol.RestoreResponse;
import io.atomix.protocols.backup.service.impl.PrimaryBackupServiceContext;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;

public abstract class PrimaryBackupRole {
    protected final Logger log;
    private final PrimaryBackupServer.Role role;
    protected final PrimaryBackupServiceContext context;

    protected PrimaryBackupRole(PrimaryBackupServer.Role role, PrimaryBackupServiceContext context) {
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(this.getClass()).addValue((Object)context.serverName()).add("role", (Object)role).build());
        this.role = role;
        this.context = context;
    }

    public PrimaryBackupServer.Role role() {
        return this.role;
    }

    protected final <R extends PrimaryBackupRequest> R logRequest(R request) {
        this.log.trace("Received {}", request);
        return request;
    }

    protected final <R extends PrimaryBackupResponse> R logResponse(R response) {
        this.log.trace("Sending {}", response);
        return response;
    }

    public CompletableFuture<ExecuteResponse> execute(ExecuteRequest request) {
        this.logRequest(request);
        return CompletableFuture.completedFuture(this.logResponse(ExecuteResponse.error()));
    }

    public CompletableFuture<BackupResponse> backup(BackupRequest request) {
        this.logRequest(request);
        return CompletableFuture.completedFuture(this.logResponse(BackupResponse.error()));
    }

    public CompletableFuture<RestoreResponse> restore(RestoreRequest request) {
        this.logRequest(request);
        return CompletableFuture.completedFuture(this.logResponse(RestoreResponse.error()));
    }

    public CompletableFuture<Void> expire(PrimaryBackupSession session) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> close(PrimaryBackupSession session) {
        return CompletableFuture.completedFuture(null);
    }

    public void close() {
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("role", (Object)this.role).toString();
    }
}

