/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup;

import io.atomix.primitive.Consistency;
import io.atomix.primitive.Recovery;
import io.atomix.primitive.Replication;
import io.atomix.primitive.partition.Partitioner;
import io.atomix.primitive.protocol.PrimitiveProtocolBuilder;
import io.atomix.primitive.protocol.PrimitiveProtocolConfig;
import io.atomix.protocols.backup.MultiPrimaryProtocol;
import io.atomix.protocols.backup.MultiPrimaryProtocolConfig;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class MultiPrimaryProtocolBuilder
extends PrimitiveProtocolBuilder<MultiPrimaryProtocolBuilder, MultiPrimaryProtocolConfig, MultiPrimaryProtocol> {
    protected MultiPrimaryProtocolBuilder(MultiPrimaryProtocolConfig config) {
        super((PrimitiveProtocolConfig)config);
    }

    public MultiPrimaryProtocolBuilder withPartitioner(Partitioner<String> partitioner) {
        ((MultiPrimaryProtocolConfig)this.config).setPartitioner(partitioner);
        return this;
    }

    public MultiPrimaryProtocolBuilder withConsistency(Consistency consistency) {
        ((MultiPrimaryProtocolConfig)this.config).setConsistency(consistency);
        return this;
    }

    public MultiPrimaryProtocolBuilder withReplication(Replication replication) {
        ((MultiPrimaryProtocolConfig)this.config).setReplication(replication);
        return this;
    }

    public MultiPrimaryProtocolBuilder withRecovery(Recovery recovery) {
        ((MultiPrimaryProtocolConfig)this.config).setRecovery(recovery);
        return this;
    }

    public MultiPrimaryProtocolBuilder withBackups(int numBackups) {
        ((MultiPrimaryProtocolConfig)this.config).setBackups(numBackups);
        return this;
    }

    public MultiPrimaryProtocolBuilder withMaxRetries(int maxRetries) {
        ((MultiPrimaryProtocolConfig)this.config).setMaxRetries(maxRetries);
        return this;
    }

    public MultiPrimaryProtocolBuilder withRetryDelayMillis(long retryDelayMillis) {
        ((MultiPrimaryProtocolConfig)this.config).setRetryDelayMillis(retryDelayMillis);
        return this;
    }

    public MultiPrimaryProtocolBuilder withRetryDelay(long retryDelay, TimeUnit timeUnit) {
        return this.withRetryDelay(Duration.ofMillis(timeUnit.toMillis(retryDelay)));
    }

    public MultiPrimaryProtocolBuilder withRetryDelay(Duration retryDelay) {
        ((MultiPrimaryProtocolConfig)this.config).setRetryDelay(retryDelay);
        return this;
    }

    public MultiPrimaryProtocol build() {
        return new MultiPrimaryProtocol((MultiPrimaryProtocolConfig)this.config);
    }
}

