/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup.impl;

import io.atomix.cluster.MemberId;
import io.atomix.primitive.event.PrimitiveEvent;
import io.atomix.primitive.session.Session;
import io.atomix.primitive.session.SessionId;
import io.atomix.primitive.session.impl.AbstractSession;
import io.atomix.protocols.backup.PrimaryBackupServer;
import io.atomix.protocols.backup.service.impl.PrimaryBackupServiceContext;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import io.atomix.utils.serializer.Serializer;
import org.slf4j.Logger;

public class PrimaryBackupSession
extends AbstractSession {
    private final Logger log;
    private final PrimaryBackupServiceContext context;
    private Session.State state = Session.State.OPEN;

    public PrimaryBackupSession(SessionId sessionId, MemberId memberId, Serializer serializer, PrimaryBackupServiceContext context) {
        super(sessionId, context.serviceName(), context.serviceType(), memberId, serializer);
        this.context = context;
        this.log = ContextualLoggerFactory.getLogger(((Object)((Object)this)).getClass(), (LoggerContext)LoggerContext.builder(((Object)((Object)this)).getClass()).addValue((Object)context.serverName()).add("session", (Object)sessionId).build());
    }

    public Session.State getState() {
        return this.state;
    }

    public void publish(PrimitiveEvent event) {
        if (this.context.getRole() == PrimaryBackupServer.Role.PRIMARY) {
            this.context.threadContext().execute(() -> {
                this.log.trace("Sending {} to {}", (Object)event, (Object)this.memberId());
                this.context.protocol().event(this.memberId(), this.sessionId(), event);
            });
        }
    }

    public void expire() {
        this.state = Session.State.EXPIRED;
    }

    public void close() {
        this.state = Session.State.CLOSED;
    }
}

