/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup.protocol;

import com.google.common.base.MoreObjects;
import io.atomix.protocols.backup.protocol.PrimaryBackupResponse;
import io.atomix.utils.ArraySizeHashPrinter;

public class RestoreResponse
extends PrimaryBackupResponse {
    private final long index;
    private final long timestamp;
    private final byte[] data;

    public static RestoreResponse ok(long index, long timestamp, byte[] data) {
        return new RestoreResponse(PrimaryBackupResponse.Status.OK, index, timestamp, data);
    }

    public static RestoreResponse error() {
        return new RestoreResponse(PrimaryBackupResponse.Status.ERROR, 0L, 0L, null);
    }

    private RestoreResponse(PrimaryBackupResponse.Status status, long index, long timestamp, byte[] data) {
        super(status);
        this.index = index;
        this.timestamp = timestamp;
        this.data = data;
    }

    public long index() {
        return this.index;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public byte[] data() {
        return this.data;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status()).add("index", this.index()).add("timestamp", this.timestamp()).add("data", this.data != null ? ArraySizeHashPrinter.of((byte[])this.data) : null).toString();
    }
}

