/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup.partition;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.atomix.primitive.PrimitiveProtocol;
import io.atomix.primitive.partition.ManagedPartitionGroup;
import io.atomix.primitive.partition.Partition;
import io.atomix.primitive.partition.PartitionGroup;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PartitionManagementService;
import io.atomix.protocols.backup.MultiPrimaryProtocol;
import io.atomix.protocols.backup.partition.PrimaryBackupPartition;
import io.atomix.utils.concurrent.ThreadContextFactory;
import io.atomix.utils.concurrent.ThreadPoolContextFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimaryBackupPartitionGroup
implements ManagedPartitionGroup {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrimaryBackupPartitionGroup.class);
    private final String name;
    private final Map<PartitionId, PrimaryBackupPartition> partitions = Maps.newConcurrentMap();
    private final List<PartitionId> sortedPartitionIds = Lists.newCopyOnWriteArrayList();
    private ThreadContextFactory threadFactory;

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public PrimaryBackupPartitionGroup(String name, Collection<PrimaryBackupPartition> partitions) {
        this.name = name;
        partitions.forEach(p -> {
            this.partitions.put(p.id(), (PrimaryBackupPartition)p);
            this.sortedPartitionIds.add(p.id());
        });
        Collections.sort(this.sortedPartitionIds);
    }

    public String name() {
        return this.name;
    }

    public PrimitiveProtocol.Type type() {
        return MultiPrimaryProtocol.TYPE;
    }

    public Partition getPartition(PartitionId partitionId) {
        return this.partitions.get(partitionId);
    }

    public Collection<Partition> getPartitions() {
        return this.partitions.values();
    }

    public List<PartitionId> getPartitionIds() {
        return this.sortedPartitionIds;
    }

    public CompletableFuture<ManagedPartitionGroup> open(PartitionManagementService managementService) {
        this.threadFactory = new ThreadPoolContextFactory("atomix-" + this.name() + "-%d", Runtime.getRuntime().availableProcessors() * 2, LOGGER);
        List<CompletableFuture> futures = this.partitions.values().stream().map(p -> p.open(managementService, this.threadFactory)).collect(Collectors.toList());
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenApply(v -> {
            LOGGER.info("Started");
            return this;
        });
    }

    public CompletableFuture<Void> close() {
        List<CompletableFuture> futures = this.partitions.values().stream().map(PrimaryBackupPartition::close).collect(Collectors.toList());
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenRun(() -> {
            this.threadFactory.close();
            LOGGER.info("Stopped");
        });
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("partitions", this.partitions).toString();
    }

    public static class Builder
    extends PartitionGroup.Builder {
        private int numPartitions;

        protected Builder(String name) {
            super(name);
        }

        public Builder withNumPartitions(int numPartitions) {
            Preconditions.checkArgument((numPartitions > 0 ? 1 : 0) != 0, (Object)"numPartitions must be positive");
            this.numPartitions = numPartitions;
            return this;
        }

        public ManagedPartitionGroup build() {
            ArrayList<PrimaryBackupPartition> partitions = new ArrayList<PrimaryBackupPartition>(this.numPartitions);
            for (int i = 0; i < this.numPartitions; ++i) {
                partitions.add(new PrimaryBackupPartition(PartitionId.from((String)this.name, (int)(i + 1))));
            }
            return new PrimaryBackupPartitionGroup(this.name, partitions);
        }
    }
}

