/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup.impl;

import com.google.common.collect.Sets;
import io.atomix.cluster.NodeId;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.event.PrimitiveEvent;
import io.atomix.primitive.session.Session;
import io.atomix.primitive.session.SessionEvent;
import io.atomix.primitive.session.SessionEventListener;
import io.atomix.primitive.session.SessionId;
import io.atomix.protocols.backup.PrimaryBackupServer;
import io.atomix.protocols.backup.service.impl.PrimaryBackupServiceContext;
import io.atomix.utils.event.Event;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import java.util.Set;
import org.slf4j.Logger;

public class PrimaryBackupSession
implements Session {
    private final Logger log;
    private final SessionId sessionId;
    private final NodeId nodeId;
    private final PrimaryBackupServiceContext context;
    private final Set<SessionEventListener> eventListeners = Sets.newIdentityHashSet();
    private Session.State state = Session.State.OPEN;

    public PrimaryBackupSession(SessionId sessionId, NodeId nodeId, PrimaryBackupServiceContext context) {
        this.sessionId = sessionId;
        this.nodeId = nodeId;
        this.context = context;
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(this.getClass()).addValue((Object)context.serverName()).add("session", (Object)sessionId).build());
    }

    public SessionId sessionId() {
        return this.sessionId;
    }

    public String serviceName() {
        return this.context.serviceName();
    }

    public PrimitiveType serviceType() {
        return this.context.serviceType();
    }

    public NodeId nodeId() {
        return this.nodeId;
    }

    public Session.State getState() {
        return this.state;
    }

    public void addListener(SessionEventListener listener) {
        this.eventListeners.add(listener);
    }

    public void removeListener(SessionEventListener listener) {
        this.eventListeners.remove(listener);
    }

    public void publish(PrimitiveEvent event) {
        if (this.context.getRole() == PrimaryBackupServer.Role.PRIMARY) {
            this.context.threadContext().execute(() -> {
                this.log.trace("Sending {} to {}", (Object)event, (Object)this.nodeId);
                this.context.protocol().event(this.nodeId, this.sessionId, event);
            });
        }
    }

    public void expire() {
        this.state = Session.State.EXPIRED;
        this.eventListeners.forEach(l -> l.onEvent((Event)new SessionEvent(SessionEvent.Type.EXPIRE, (Session)this)));
    }

    public void close() {
        this.state = Session.State.CLOSED;
        this.eventListeners.forEach(l -> l.onEvent((Event)new SessionEvent(SessionEvent.Type.CLOSE, (Session)this)));
    }
}

