/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.primitive.Consistency;
import io.atomix.primitive.PrimitiveProtocol;
import io.atomix.primitive.Recovery;
import io.atomix.primitive.Replication;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class MultiPrimaryProtocol
implements PrimitiveProtocol {
    public static final PrimitiveProtocol.Type TYPE = new PrimitiveProtocol.Type(){};
    private final String group;
    private final Consistency consistency;
    private final Replication replication;
    private final Recovery recovery;
    private final int backups;
    private final int maxRetries;
    private final Duration retryDelay;
    private final Executor executor;

    public static Builder builder() {
        return MultiPrimaryProtocol.builder(null);
    }

    public static Builder builder(String group) {
        return new Builder(group);
    }

    protected MultiPrimaryProtocol(String group, Consistency consistency, Replication replication, Recovery recovery, int backups, int maxRetries, Duration retryDelay, Executor executor) {
        this.group = group;
        this.consistency = consistency;
        this.replication = replication;
        this.recovery = recovery;
        this.backups = backups;
        this.maxRetries = maxRetries;
        this.retryDelay = retryDelay;
        this.executor = executor;
    }

    public PrimitiveProtocol.Type type() {
        return TYPE;
    }

    public String group() {
        return this.group;
    }

    public Consistency consistency() {
        return this.consistency;
    }

    public Replication replication() {
        return this.replication;
    }

    public Recovery recovery() {
        return this.recovery;
    }

    public int backups() {
        return this.backups;
    }

    public int maxRetries() {
        return this.maxRetries;
    }

    public Duration retryDelay() {
        return this.retryDelay;
    }

    public Executor executor() {
        return this.executor;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type()).add("group", (Object)this.group()).add("consistency", (Object)this.consistency()).add("replication", (Object)this.replication()).add("backups", this.backups()).add("maxRetries", this.maxRetries).add("retryDelay", (Object)this.retryDelay).toString();
    }

    public static class Builder
    extends PrimitiveProtocol.Builder {
        private Consistency consistency = Consistency.SEQUENTIAL;
        private Replication replication = Replication.SYNCHRONOUS;
        private Recovery recovery = Recovery.RECOVER;
        private int numBackups;
        private int maxRetries = 0;
        private Duration retryDelay = Duration.ofMillis(100L);
        private Executor executor;

        protected Builder(String group) {
            super(group);
        }

        public Builder withConsistency(Consistency consistency) {
            this.consistency = (Consistency)Preconditions.checkNotNull((Object)consistency, (Object)"consistency cannot be null");
            return this;
        }

        public Builder withReplication(Replication replication) {
            this.replication = (Replication)Preconditions.checkNotNull((Object)replication, (Object)"replication cannot be null");
            return this;
        }

        public Builder withRecovery(Recovery recovery) {
            this.recovery = (Recovery)Preconditions.checkNotNull((Object)recovery, (Object)"recovery cannot be null");
            return this;
        }

        public Builder withBackups(int numBackups) {
            Preconditions.checkArgument((numBackups >= 0 ? 1 : 0) != 0, (Object)"numBackups must be positive");
            this.numBackups = numBackups;
            return this;
        }

        public Builder withMaxRetries(int maxRetries) {
            Preconditions.checkArgument((maxRetries >= 0 ? 1 : 0) != 0, (Object)"maxRetries must be positive");
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder withRetryDelayMillis(long retryDelayMillis) {
            return this.withRetryDelay(Duration.ofMillis(retryDelayMillis));
        }

        public Builder withRetryDelay(long retryDelay, TimeUnit timeUnit) {
            return this.withRetryDelay(Duration.ofMillis(timeUnit.toMillis(retryDelay)));
        }

        public Builder withRetryDelay(Duration retryDelay) {
            this.retryDelay = (Duration)Preconditions.checkNotNull((Object)retryDelay, (Object)"retryDelay cannot be null");
            return this;
        }

        public Builder withExecutor(Executor executor) {
            this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor cannot be null");
            return this;
        }

        public MultiPrimaryProtocol build() {
            return new MultiPrimaryProtocol(this.group, this.consistency, this.replication, this.recovery, this.numBackups, this.maxRetries, this.retryDelay, this.executor);
        }
    }
}

