/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.log.roles;

import com.google.common.base.MoreObjects;
import io.atomix.protocols.log.DistributedLogServer;
import io.atomix.protocols.log.impl.DistributedLogServerContext;
import io.atomix.protocols.log.protocol.AppendRequest;
import io.atomix.protocols.log.protocol.AppendResponse;
import io.atomix.protocols.log.protocol.BackupRequest;
import io.atomix.protocols.log.protocol.BackupResponse;
import io.atomix.protocols.log.protocol.ConsumeRequest;
import io.atomix.protocols.log.protocol.ConsumeResponse;
import io.atomix.protocols.log.protocol.LogRequest;
import io.atomix.protocols.log.protocol.LogResponse;
import io.atomix.protocols.log.protocol.ResetRequest;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;

public abstract class LogServerRole {
    protected final Logger log;
    private final DistributedLogServer.Role role;
    protected final DistributedLogServerContext context;

    protected LogServerRole(DistributedLogServer.Role role, DistributedLogServerContext context) {
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(this.getClass()).addValue((Object)context.serverName()).add("role", (Object)role).build());
        this.role = role;
        this.context = context;
    }

    public DistributedLogServer.Role role() {
        return this.role;
    }

    protected final <R extends LogRequest> R logRequest(R request) {
        this.log.trace("Received {}", request);
        return request;
    }

    protected final <R extends LogResponse> R logResponse(R response) {
        this.log.trace("Sending {}", response);
        return response;
    }

    public CompletableFuture<AppendResponse> append(AppendRequest request) {
        this.logRequest(request);
        return CompletableFuture.completedFuture(this.logResponse(AppendResponse.error()));
    }

    public CompletableFuture<ConsumeResponse> consume(ConsumeRequest request) {
        this.logRequest(request);
        return CompletableFuture.completedFuture(this.logResponse(ConsumeResponse.error()));
    }

    public void reset(ResetRequest request) {
        this.logRequest(request);
    }

    public CompletableFuture<BackupResponse> backup(BackupRequest request) {
        this.logRequest(request);
        return CompletableFuture.completedFuture(this.logResponse(BackupResponse.error()));
    }

    public void close() {
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("role", (Object)this.role).toString();
    }
}

