/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.log;

import com.google.common.base.Preconditions;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.primitive.log.LogSession;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PrimaryElection;
import io.atomix.primitive.session.SessionId;
import io.atomix.protocols.log.impl.DistributedLogSession;
import io.atomix.protocols.log.protocol.LogClientProtocol;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.concurrent.ThreadContextFactory;
import io.atomix.utils.concurrent.ThreadModel;
import io.atomix.utils.logging.ContextualLogger;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class DistributedLogSessionClient {
    private final String clientName;
    private final PartitionId partitionId;
    private final ClusterMembershipService clusterMembershipService;
    private final LogClientProtocol protocol;
    private final Supplier<CompletableFuture<SessionId>> sessionIdProvider;
    private final PrimaryElection primaryElection;
    private final ThreadContextFactory threadContextFactory;
    private final ThreadContext threadContext;
    private final boolean closeOnStop;

    public static Builder builder() {
        return new Builder();
    }

    public DistributedLogSessionClient(String clientName, PartitionId partitionId, ClusterMembershipService clusterMembershipService, LogClientProtocol protocol, Supplier<CompletableFuture<SessionId>> sessionIdProvider, PrimaryElection primaryElection, ThreadContextFactory threadContextFactory, boolean closeOnStop) {
        this.clientName = clientName;
        this.partitionId = partitionId;
        this.clusterMembershipService = clusterMembershipService;
        this.protocol = protocol;
        this.sessionIdProvider = sessionIdProvider;
        this.primaryElection = primaryElection;
        this.threadContextFactory = threadContextFactory;
        this.threadContext = threadContextFactory.createContext();
        this.closeOnStop = closeOnStop;
    }

    public LogSession.Builder sessionBuilder() {
        return new LogSession.Builder(){

            public LogSession build() {
                return new DistributedLogSession(DistributedLogSessionClient.this.partitionId, (SessionId)((CompletableFuture)DistributedLogSessionClient.this.sessionIdProvider.get()).join(), DistributedLogSessionClient.this.clusterMembershipService, DistributedLogSessionClient.this.protocol, DistributedLogSessionClient.this.primaryElection, DistributedLogSessionClient.this.threadContextFactory.createContext());
            }
        };
    }

    public CompletableFuture<Void> close() {
        this.threadContext.close();
        if (this.closeOnStop) {
            this.threadContextFactory.close();
        }
        return CompletableFuture.completedFuture(null);
    }

    public static class Builder
    implements io.atomix.utils.Builder<DistributedLogSessionClient> {
        protected String clientName = "atomix";
        protected PartitionId partitionId;
        protected ClusterMembershipService clusterMembershipService;
        protected LogClientProtocol protocol;
        protected Supplier<CompletableFuture<SessionId>> sessionIdProvider;
        protected PrimaryElection primaryElection;
        protected ThreadModel threadModel = ThreadModel.SHARED_THREAD_POOL;
        protected int threadPoolSize = Math.max(Math.min(Runtime.getRuntime().availableProcessors() * 2, 16), 4);
        protected ThreadContextFactory threadContextFactory;

        public Builder withClientName(String clientName) {
            this.clientName = (String)Preconditions.checkNotNull((Object)clientName, (Object)"clientName cannot be null");
            return this;
        }

        public Builder withPartitionId(PartitionId partitionId) {
            this.partitionId = (PartitionId)Preconditions.checkNotNull((Object)partitionId, (Object)"partitionId cannot be null");
            return this;
        }

        public Builder withMembershipService(ClusterMembershipService membershipService) {
            this.clusterMembershipService = (ClusterMembershipService)Preconditions.checkNotNull((Object)membershipService, (Object)"membershipService cannot be null");
            return this;
        }

        public Builder withProtocol(LogClientProtocol protocol) {
            this.protocol = (LogClientProtocol)Preconditions.checkNotNull((Object)protocol, (Object)"protocol cannot be null");
            return this;
        }

        public Builder withSessionIdProvider(Supplier<CompletableFuture<SessionId>> sessionIdProvider) {
            this.sessionIdProvider = (Supplier)Preconditions.checkNotNull(sessionIdProvider, (Object)"sessionIdProvider cannot be null");
            return this;
        }

        public Builder withPrimaryElection(PrimaryElection primaryElection) {
            this.primaryElection = (PrimaryElection)Preconditions.checkNotNull((Object)primaryElection, (Object)"primaryElection cannot be null");
            return this;
        }

        public Builder withThreadModel(ThreadModel threadModel) {
            this.threadModel = (ThreadModel)Preconditions.checkNotNull((Object)threadModel, (Object)"threadModel cannot be null");
            return this;
        }

        public Builder withThreadPoolSize(int threadPoolSize) {
            Preconditions.checkArgument((threadPoolSize > 0 ? 1 : 0) != 0, (Object)"threadPoolSize must be positive");
            this.threadPoolSize = threadPoolSize;
            return this;
        }

        public Builder withThreadContextFactory(ThreadContextFactory threadContextFactory) {
            this.threadContextFactory = (ThreadContextFactory)Preconditions.checkNotNull((Object)threadContextFactory, (Object)"threadContextFactory cannot be null");
            return this;
        }

        public DistributedLogSessionClient build() {
            boolean closeOnStop;
            ThreadContextFactory threadContextFactory;
            ContextualLogger log = ContextualLoggerFactory.getLogger(DistributedLogSessionClient.class, (LoggerContext)LoggerContext.builder(DistributedLogSessionClient.class).addValue((Object)this.clientName).build());
            if (this.threadContextFactory == null) {
                threadContextFactory = this.threadModel.factory("log-client-" + this.clientName + "-%d", this.threadPoolSize, (Logger)log);
                closeOnStop = true;
            } else {
                threadContextFactory = this.threadContextFactory;
                closeOnStop = false;
            }
            return new DistributedLogSessionClient(this.clientName, this.partitionId, this.clusterMembershipService, this.protocol, this.sessionIdProvider, this.primaryElection, threadContextFactory, closeOnStop);
        }
    }
}

