/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.log;

import com.google.common.base.Preconditions;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.log.LogClient;
import io.atomix.primitive.log.LogSession;
import io.atomix.primitive.partition.PartitionService;
import io.atomix.primitive.protocol.LogProtocol;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.ProxyProtocol;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.primitive.proxy.impl.LogProxyClient;
import io.atomix.primitive.service.ServiceConfig;
import io.atomix.protocols.log.DistributedLogProtocolBuilder;
import io.atomix.protocols.log.DistributedLogProtocolConfig;
import io.atomix.protocols.log.impl.DistributedLogClient;
import io.atomix.protocols.log.partition.LogPartition;
import java.util.Collection;
import java.util.stream.Collectors;

public class DistributedLogProtocol
implements LogProtocol {
    public static final Type TYPE = new Type();
    private final DistributedLogProtocolConfig config;

    public static DistributedLogProtocol instance() {
        return new DistributedLogProtocol(new DistributedLogProtocolConfig());
    }

    public static DistributedLogProtocolBuilder builder() {
        return new DistributedLogProtocolBuilder(new DistributedLogProtocolConfig());
    }

    public static DistributedLogProtocolBuilder builder(String group) {
        return new DistributedLogProtocolBuilder(new DistributedLogProtocolConfig().setGroup(group));
    }

    protected DistributedLogProtocol(DistributedLogProtocolConfig config) {
        this.config = (DistributedLogProtocolConfig)((Object)Preconditions.checkNotNull((Object)((Object)config), (Object)"config cannot be null"));
    }

    public PrimitiveProtocol.Type type() {
        return TYPE;
    }

    public String group() {
        return this.config.getGroup();
    }

    public LogClient newClient(PartitionService partitionService) {
        Collection partitions = partitionService.getPartitionGroup((ProxyProtocol)this).getPartitions().stream().map(partition -> (LogSession)((LogPartition)partition).getClient().logSessionBuilder().build()).collect(Collectors.toList());
        return new DistributedLogClient(this, partitions, this.config.getPartitioner());
    }

    public <S> ProxyClient<S> newProxy(String primitiveName, PrimitiveType primitiveType, Class<S> serviceType, ServiceConfig serviceConfig, PartitionService partitionService) {
        return new LogProxyClient(primitiveName, primitiveType, (PrimitiveProtocol)this, serviceType, serviceConfig, this.newClient(partitionService));
    }

    public static final class Type
    implements PrimitiveProtocol.Type<DistributedLogProtocolConfig> {
        private static final String NAME = "multi-log";

        public String name() {
            return NAME;
        }

        public DistributedLogProtocolConfig newConfig() {
            return new DistributedLogProtocolConfig();
        }

        public PrimitiveProtocol newProtocol(DistributedLogProtocolConfig config) {
            return new DistributedLogProtocol(config);
        }
    }
}

