/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.group.messaging.internal;

import io.atomix.catalyst.util.Assert;
import io.atomix.group.GroupMember;
import io.atomix.group.messaging.MessageProducer;
import io.atomix.group.messaging.internal.AbstractMessageClient;
import io.atomix.group.messaging.internal.AbstractMessageProducer;
import io.atomix.group.messaging.internal.MemberMessageProducer;
import io.atomix.group.messaging.internal.MessageProducerService;

public class MemberMessageClient
extends AbstractMessageClient {
    private final GroupMember member;

    public MemberMessageClient(GroupMember member, MessageProducerService producerService) {
        super(producerService);
        this.member = (GroupMember)Assert.notNull((Object)member, (String)"member");
    }

    @Override
    public <T> AbstractMessageProducer<T> producer(String name) {
        return this.producer(name, new MessageProducer.Options().withDelivery(MessageProducer.Delivery.DIRECT).withExecution(MessageProducer.Execution.REQUEST_REPLY));
    }

    @Override
    public <T> AbstractMessageProducer<T> producer(String name, MessageProducer.Options options) {
        return new MemberMessageProducer(name, options, this, this.member);
    }
}

