/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.group.internal;

import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.session.ServerSession;
import io.atomix.group.internal.GroupCommands;
import io.atomix.group.internal.MembersState;
import io.atomix.group.internal.QueueState;
import io.atomix.group.messaging.MessageProducer;

abstract class MessageState
implements AutoCloseable {
    protected final Commit<GroupCommands.Message> commit;
    protected final QueueState queue;
    private boolean complete;

    protected MessageState(Commit<GroupCommands.Message> commit, QueueState queue) {
        this.commit = commit;
        this.queue = queue;
    }

    public String queue() {
        return ((GroupCommands.Message)this.commit.operation()).queue();
    }

    public long index() {
        return this.commit.index();
    }

    public ServerSession session() {
        return this.commit.session();
    }

    public Object message() {
        return ((GroupCommands.Message)this.commit.operation()).message();
    }

    public MessageProducer.Execution execution() {
        return ((GroupCommands.Message)this.commit.operation()).execution();
    }

    public abstract boolean send(MembersState var1);

    public abstract void reply(GroupCommands.Reply var1);

    public abstract void expire();

    protected boolean sendReply(boolean succeeded, Object message) {
        if (!this.complete && this.session().state().active()) {
            this.session().publish("ack", (Object)new GroupCommands.Ack(((GroupCommands.Message)this.commit.operation()).member(), ((GroupCommands.Message)this.commit.operation()).producer(), ((GroupCommands.Message)this.commit.operation()).queue(), ((GroupCommands.Message)this.commit.operation()).id(), succeeded, message));
            this.complete = true;
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        this.commit.close();
    }
}

