/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.protocol;

import com.google.common.base.Preconditions;
import io.atomix.cluster.protocol.GroupMembershipProtocol;
import io.atomix.cluster.protocol.GroupMembershipProtocolConfig;
import io.atomix.cluster.protocol.SwimMembershipProtocol;
import java.time.Duration;

public class SwimMembershipProtocolConfig
extends GroupMembershipProtocolConfig {
    private static final boolean DEFAULT_BROADCAST_UPDATES = false;
    private static final boolean DEFAULT_BROADCAST_DISPUTES = true;
    private static final boolean DEFAULT_NOTIFY_SUSPECT = false;
    private static final int DEFAULT_GOSSIP_INTERVAL = 250;
    private static final int DEFAULT_GOSSIP_FANOUT = 2;
    private static final int DEFAULT_PROBE_INTERVAL = 1000;
    private static final int DEFAULT_PROBE_TIMEOUT = 2000;
    private static final int DEFAULT_SUSPECT_PROBES = 3;
    private static final int DEFAULT_FAILURE_TIMEOUT = 10000;
    private boolean broadcastUpdates = false;
    private boolean broadcastDisputes = true;
    private boolean notifySuspect = false;
    private Duration gossipInterval = Duration.ofMillis(250L);
    private int gossipFanout = 2;
    private Duration probeInterval = Duration.ofMillis(1000L);
    private Duration probeTimeout = Duration.ofMillis(2000L);
    private int suspectProbes = 3;
    private Duration failureTimeout = Duration.ofMillis(10000L);

    public boolean isBroadcastUpdates() {
        return this.broadcastUpdates;
    }

    public SwimMembershipProtocolConfig setBroadcastUpdates(boolean broadcastUpdates) {
        this.broadcastUpdates = broadcastUpdates;
        return this;
    }

    public boolean isBroadcastDisputes() {
        return this.broadcastDisputes;
    }

    public SwimMembershipProtocolConfig setBroadcastDisputes(boolean broadcastDisputes) {
        this.broadcastDisputes = broadcastDisputes;
        return this;
    }

    public boolean isNotifySuspect() {
        return this.notifySuspect;
    }

    public SwimMembershipProtocolConfig setNotifySuspect(boolean notifySuspect) {
        this.notifySuspect = notifySuspect;
        return this;
    }

    public Duration getGossipInterval() {
        return this.gossipInterval;
    }

    public SwimMembershipProtocolConfig setGossipInterval(Duration gossipInterval) {
        this.gossipInterval = gossipInterval;
        return this;
    }

    public int getGossipFanout() {
        return this.gossipFanout;
    }

    public SwimMembershipProtocolConfig setGossipFanout(int gossipFanout) {
        Preconditions.checkArgument((gossipFanout > 0 ? 1 : 0) != 0, (Object)"gossipFanout must be positive");
        this.gossipFanout = gossipFanout;
        return this;
    }

    public Duration getProbeInterval() {
        return this.probeInterval;
    }

    public SwimMembershipProtocolConfig setProbeInterval(Duration probeInterval) {
        Preconditions.checkNotNull((Object)probeInterval, (Object)"probeInterval cannot be null");
        Preconditions.checkArgument((!probeInterval.isNegative() && !probeInterval.isZero() ? 1 : 0) != 0, (Object)"probeInterval must be positive");
        this.probeInterval = probeInterval;
        return this;
    }

    public Duration getProbeTimeout() {
        return this.probeTimeout;
    }

    public SwimMembershipProtocolConfig setProbeTimeout(Duration probeTimeout) {
        Preconditions.checkNotNull((Object)probeTimeout, (Object)"probeTimeout cannot be null");
        Preconditions.checkArgument((!probeTimeout.isNegative() && !probeTimeout.isZero() ? 1 : 0) != 0, (Object)"probeTimeout must be positive");
        this.probeTimeout = probeTimeout;
        return this;
    }

    public int getSuspectProbes() {
        return this.suspectProbes;
    }

    public SwimMembershipProtocolConfig setSuspectProbes(int suspectProbes) {
        Preconditions.checkArgument((suspectProbes > 0 ? 1 : 0) != 0, (Object)"suspectProbes must be positive");
        this.suspectProbes = suspectProbes;
        return this;
    }

    public Duration getFailureTimeout() {
        return this.failureTimeout;
    }

    public SwimMembershipProtocolConfig setFailureTimeout(Duration failureTimeout) {
        Preconditions.checkNotNull((Object)failureTimeout, (Object)"failureTimeout cannot be null");
        Preconditions.checkArgument((!failureTimeout.isNegative() && !failureTimeout.isZero() ? 1 : 0) != 0, (Object)"failureTimeout must be positive");
        this.failureTimeout = (Duration)Preconditions.checkNotNull((Object)failureTimeout);
        return this;
    }

    public GroupMembershipProtocol.Type getType() {
        return SwimMembershipProtocol.TYPE;
    }
}

