/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging;

import io.atomix.cluster.messaging.Subscription;
import io.atomix.utils.serializer.Serializer;
import io.atomix.utils.serializer.serializers.DefaultSerializers;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;

public interface ClusterEventService {
    default public <M> void broadcast(String topic, M message) {
        this.broadcast(topic, message, arg_0 -> ((Serializer)DefaultSerializers.BASIC).encode(arg_0));
    }

    public <M> void broadcast(String var1, M var2, Function<M, byte[]> var3);

    default public <M> CompletableFuture<Void> unicast(String topic, M message) {
        return this.unicast(topic, message, arg_0 -> ((Serializer)DefaultSerializers.BASIC).encode(arg_0));
    }

    public <M> CompletableFuture<Void> unicast(String var1, M var2, Function<M, byte[]> var3);

    default public <M, R> CompletableFuture<R> send(String topic, M message) {
        return this.send(topic, message, arg_0 -> ((Serializer)DefaultSerializers.BASIC).encode(arg_0), arg_0 -> ((Serializer)DefaultSerializers.BASIC).decode(arg_0), null);
    }

    default public <M, R> CompletableFuture<R> send(String topic, M message, Duration timeout) {
        return this.send(topic, message, arg_0 -> ((Serializer)DefaultSerializers.BASIC).encode(arg_0), arg_0 -> ((Serializer)DefaultSerializers.BASIC).decode(arg_0), timeout);
    }

    default public <M, R> CompletableFuture<R> send(String topic, M message, Function<M, byte[]> encoder, Function<byte[], R> decoder) {
        return this.send(topic, message, encoder, decoder, null);
    }

    public <M, R> CompletableFuture<R> send(String var1, M var2, Function<M, byte[]> var3, Function<byte[], R> var4, Duration var5);

    default public <M, R> CompletableFuture<Subscription> subscribe(String topic, Function<M, R> handler, Executor executor) {
        return this.subscribe(topic, arg_0 -> ((Serializer)DefaultSerializers.BASIC).decode(arg_0), handler, arg_0 -> ((Serializer)DefaultSerializers.BASIC).encode(arg_0), executor);
    }

    public <M, R> CompletableFuture<Subscription> subscribe(String var1, Function<byte[], M> var2, Function<M, R> var3, Function<R, byte[]> var4, Executor var5);

    default public <M, R> CompletableFuture<Subscription> subscribe(String topic, Function<M, CompletableFuture<R>> handler) {
        return this.subscribe(topic, arg_0 -> ((Serializer)DefaultSerializers.BASIC).decode(arg_0), handler, arg_0 -> ((Serializer)DefaultSerializers.BASIC).encode(arg_0));
    }

    public <M, R> CompletableFuture<Subscription> subscribe(String var1, Function<byte[], M> var2, Function<M, CompletableFuture<R>> var3, Function<R, byte[]> var4);

    default public <M> CompletableFuture<Subscription> subscribe(String topic, Consumer<M> handler, Executor executor) {
        return this.subscribe(topic, arg_0 -> ((Serializer)DefaultSerializers.BASIC).decode(arg_0), handler, executor);
    }

    public <M> CompletableFuture<Subscription> subscribe(String var1, Function<byte[], M> var2, Consumer<M> var3, Executor var4);

    public List<Subscription> getSubscriptions(String var1);
}

