/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import com.google.common.base.Preconditions;
import io.atomix.cluster.messaging.impl.DecoderState;
import io.atomix.cluster.messaging.impl.InternalMessage;
import io.atomix.cluster.messaging.impl.InternalReply;
import io.atomix.cluster.messaging.impl.InternalRequest;
import io.atomix.utils.net.Address;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDecoder
extends ByteToMessageDecoder {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final byte[] EMPTY_PAYLOAD = new byte[0];
    private static final int BYTE_SIZE = 1;
    private static final int SHORT_SIZE = 2;
    private static final int INT_SIZE = 4;
    private static final int LONG_SIZE = 8;
    private DecoderState currentState = DecoderState.READ_SENDER_VERSION;
    private InetAddress senderIp;
    private int senderPort;
    private Address address;
    private int version;
    private InternalMessage.Type type;
    private int preamble;
    private long messageId;
    private int contentLength;
    private byte[] content;
    private int subjectLength;

    protected void decode(ChannelHandlerContext context, ByteBuf buffer, List<Object> out) throws Exception {
        block0 : switch (this.currentState) {
            case READ_SENDER_VERSION: {
                if (buffer.readableBytes() < 2) {
                    return;
                }
                this.version = buffer.readShort();
                this.currentState = DecoderState.READ_SENDER_IP;
            }
            case READ_SENDER_IP: {
                if (buffer.readableBytes() < 1) {
                    return;
                }
                buffer.markReaderIndex();
                byte octetsLength = buffer.readByte();
                if (buffer.readableBytes() < octetsLength) {
                    buffer.resetReaderIndex();
                    return;
                }
                byte[] octets = new byte[octetsLength];
                buffer.readBytes(octets);
                this.senderIp = InetAddress.getByAddress(octets);
                this.currentState = DecoderState.READ_SENDER_PORT;
            }
            case READ_SENDER_PORT: {
                if (buffer.readableBytes() < 4) {
                    return;
                }
                this.senderPort = buffer.readInt();
                this.address = new Address(this.senderIp.getHostName(), this.senderPort, this.senderIp);
                this.currentState = DecoderState.READ_TYPE;
            }
            case READ_TYPE: {
                if (buffer.readableBytes() < 1) {
                    return;
                }
                this.type = InternalMessage.Type.forId(buffer.readByte());
                this.currentState = DecoderState.READ_PREAMBLE;
            }
            case READ_PREAMBLE: {
                if (buffer.readableBytes() < 4) {
                    return;
                }
                this.preamble = buffer.readInt();
                this.currentState = DecoderState.READ_MESSAGE_ID;
            }
            case READ_MESSAGE_ID: {
                if (buffer.readableBytes() < 8) {
                    return;
                }
                this.messageId = buffer.readLong();
                this.currentState = DecoderState.READ_CONTENT_LENGTH;
            }
            case READ_CONTENT_LENGTH: {
                if (buffer.readableBytes() < 4) {
                    return;
                }
                this.contentLength = buffer.readInt();
                this.currentState = DecoderState.READ_CONTENT;
            }
            case READ_CONTENT: {
                if (buffer.readableBytes() < this.contentLength) {
                    return;
                }
                if (this.contentLength > 0) {
                    this.content = new byte[this.contentLength];
                    buffer.readBytes(this.content);
                } else {
                    this.content = EMPTY_PAYLOAD;
                }
                switch (this.type) {
                    case REQUEST: {
                        this.currentState = DecoderState.READ_SUBJECT_LENGTH;
                        break block0;
                    }
                    case REPLY: {
                        this.currentState = DecoderState.READ_STATUS;
                        break block0;
                    }
                }
                Preconditions.checkState((boolean)false, (Object)"Must not be here");
                break;
            }
        }
        block14 : switch (this.type) {
            case REQUEST: {
                InternalMessage message;
                switch (this.currentState) {
                    case READ_SUBJECT_LENGTH: {
                        if (buffer.readableBytes() < 2) {
                            return;
                        }
                        this.subjectLength = buffer.readShort();
                        this.currentState = DecoderState.READ_SUBJECT;
                    }
                    case READ_SUBJECT: {
                        if (buffer.readableBytes() < this.subjectLength) {
                            return;
                        }
                        String subject = MessageDecoder.readString(buffer, this.subjectLength, StandardCharsets.UTF_8);
                        message = new InternalRequest(this.preamble, this.messageId, this.address, subject, this.content);
                        out.add(message);
                        this.currentState = DecoderState.READ_TYPE;
                        break block14;
                    }
                }
                break;
            }
            case REPLY: {
                InternalMessage message;
                switch (this.currentState) {
                    case READ_STATUS: {
                        if (buffer.readableBytes() < 1) {
                            return;
                        }
                        InternalReply.Status status = InternalReply.Status.forId(buffer.readByte());
                        message = new InternalReply(this.preamble, this.messageId, this.content, status);
                        out.add(message);
                        this.currentState = DecoderState.READ_TYPE;
                        break block14;
                    }
                }
                break;
            }
            default: {
                Preconditions.checkState((boolean)false, (Object)"Must not be here");
            }
        }
    }

    static String readString(ByteBuf buffer, int length, Charset charset) {
        if (buffer.isDirect()) {
            String result = buffer.toString(buffer.readerIndex(), length, charset);
            buffer.skipBytes(length);
            return result;
        }
        if (buffer.hasArray()) {
            String result = new String(buffer.array(), buffer.arrayOffset() + buffer.readerIndex(), length, charset);
            buffer.skipBytes(length);
            return result;
        }
        byte[] array = new byte[length];
        buffer.readBytes(array);
        return new String(array, charset);
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
        try {
            this.log.error("Exception inside channel handling pipeline.", cause);
        }
        finally {
            context.close();
        }
    }
}

