/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.openqa.selenium.Capabilities;

public class CapabilityHelpers {
    public static final String APPIUM_PREFIX = "appium:";

    private CapabilityHelpers() {
    }

    @Nullable
    public static <T> T getCapability(Capabilities caps, String name, Class<T> expectedType) {
        ArrayList<Object> possibleNames = new ArrayList<Object>();
        possibleNames.add(name);
        if (!name.startsWith(APPIUM_PREFIX)) {
            possibleNames.add(APPIUM_PREFIX + name);
        }
        for (String string : possibleNames) {
            if (caps.getCapability(string) == null) continue;
            if (expectedType == String.class) {
                return expectedType.cast(String.valueOf(caps.getCapability(string)));
            }
            if (!expectedType.isAssignableFrom(caps.getCapability(string).getClass())) continue;
            return expectedType.cast(caps.getCapability(string));
        }
        return null;
    }

    @Nullable
    public static Boolean toSafeBoolean(Object value) {
        return value == null ? null : Boolean.valueOf(Boolean.parseBoolean(String.valueOf(value)));
    }

    @Nullable
    public static Integer toInteger(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.parseInt(String.valueOf(value));
    }

    @Nullable
    public static Long toLong(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return Long.parseLong(String.valueOf(value));
    }

    @Nullable
    public static Double toDouble(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return Double.parseDouble(String.valueOf(value));
    }

    @Nullable
    public static Duration toDuration(Object value) {
        return CapabilityHelpers.toDuration(value, Duration::ofMillis);
    }

    @Nullable
    public static Duration toDuration(Object value, Function<Long, Duration> converter) {
        Long v = CapabilityHelpers.toLong(value);
        return v == null ? null : converter.apply(v);
    }

    @Nullable
    public static URL toUrl(Object value) {
        if (value == null) {
            return null;
        }
        try {
            return value instanceof URL ? (URL)value : new URL(String.valueOf(value));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

