/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.imagecomparison;

import io.appium.java_client.imagecomparison.ComparisonResult;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openqa.selenium.Rectangle;

public class OccurrenceMatchingResult
extends ComparisonResult {
    private static final String RECT = "rect";
    private static final String SCORE = "score";
    private final boolean hasMultiple;

    public OccurrenceMatchingResult(Object input) {
        super(input);
        this.hasMultiple = input instanceof List;
    }

    public boolean hasMultiple() {
        return this.hasMultiple;
    }

    public Rectangle getRect() {
        if (this.hasMultiple) {
            return this.getRect(0);
        }
        this.verifyPropertyPresence(RECT);
        return OccurrenceMatchingResult.mapToRect((Map)this.getResultAsMap().get(RECT));
    }

    public Rectangle getRect(int matchIndex) {
        return this.getMatch(matchIndex).getRect();
    }

    public double getScore() {
        if (this.hasMultiple) {
            return this.getScore(0);
        }
        this.verifyPropertyPresence(SCORE);
        Object value = this.getResultAsMap().get(SCORE);
        if (value instanceof Long) {
            return ((Long)value).doubleValue();
        }
        return (Double)value;
    }

    public double getScore(int matchIndex) {
        return this.getMatch(matchIndex).getScore();
    }

    @Override
    public byte[] getVisualization() {
        return this.hasMultiple ? this.getVisualization(0) : super.getVisualization();
    }

    public byte[] getVisualization(int matchIndex) {
        return this.getMatch(matchIndex).getVisualization();
    }

    @Override
    public void storeVisualization(File destination) throws IOException {
        if (this.hasMultiple) {
            this.getMatch(0).storeVisualization(destination);
        } else {
            super.storeVisualization(destination);
        }
    }

    public void storeVisualization(int matchIndex, File destination) throws IOException {
        this.getMatch(matchIndex).storeVisualization(destination);
    }

    public List<OccurrenceMatchingResult> getMultiple() {
        return this.getMultipleMatches(false);
    }

    private List<OccurrenceMatchingResult> getMultipleMatches(boolean throwIfEmpty) {
        if (!this.hasMultiple) {
            throw new IllegalStateException(String.format("This %s does not represent multiple matches. Did you set options properly?", this.getClass().getSimpleName()));
        }
        List<OccurrenceMatchingResult> matches = ((List)this.commandResult).stream().map(OccurrenceMatchingResult::new).collect(Collectors.toList());
        if (matches.isEmpty() && throwIfEmpty) {
            throw new IllegalStateException("Zero matches have been found. Try the lookup with different options.");
        }
        return matches;
    }

    private OccurrenceMatchingResult getMatch(int index) {
        List<OccurrenceMatchingResult> matches = this.getMultipleMatches(true);
        if (index < 0 || index >= matches.size()) {
            throw new IndexOutOfBoundsException(String.format("The match #%s does not exist. The total number of found matches is %s", index, matches.size()));
        }
        return matches.get(index);
    }
}

