/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import javax.annotation.Nullable;

public class Location {
    private final double latitude;
    private final double longitude;
    @Nullable
    private final Double altitude;

    public Location(double latitude, double longitude, @Nullable Double altitude) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.altitude = altitude;
    }

    public Location(double latitude, double longitude) {
        this(latitude, longitude, null);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    @Nullable
    public Double getAltitude() {
        return this.altitude;
    }

    public String toString() {
        return "Location(latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", altitude=" + this.getAltitude() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Location)) {
            return false;
        }
        Location other = (Location)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getLatitude(), other.getLatitude()) != 0) {
            return false;
        }
        if (Double.compare(this.getLongitude(), other.getLongitude()) != 0) {
            return false;
        }
        Double this$altitude = this.getAltitude();
        Double other$altitude = other.getAltitude();
        return !(this$altitude == null ? other$altitude != null : !((Object)this$altitude).equals(other$altitude));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Location;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $latitude = Double.doubleToLongBits(this.getLatitude());
        result = result * 59 + (int)($latitude >>> 32 ^ $latitude);
        long $longitude = Double.doubleToLongBits(this.getLongitude());
        result = result * 59 + (int)($longitude >>> 32 ^ $longitude);
        Double $altitude = this.getAltitude();
        result = result * 59 + ($altitude == null ? 43 : ((Object)$altitude).hashCode());
        return result;
    }
}

