/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.CanRememberExtensionPresence;
import io.appium.java_client.CommandExecutionHelper;
import io.appium.java_client.ExecutesMethod;
import io.appium.java_client.MobileCommand;
import java.time.Duration;
import java.util.Map;
import org.openqa.selenium.UnsupportedCommandException;

public interface LocksDevice
extends ExecutesMethod,
CanRememberExtensionPresence {
    default public void lockDevice() {
        this.lockDevice(Duration.ofSeconds(0L));
    }

    default public void lockDevice(Duration duration) {
        String extName = "mobile: lock";
        try {
            CommandExecutionHelper.executeScript(this.assertExtensionExists("mobile: lock"), "mobile: lock", (Map<String, Object>)ImmutableMap.of((Object)"seconds", (Object)duration.getSeconds()));
        }
        catch (UnsupportedCommandException e) {
            CommandExecutionHelper.execute(this.markExtensionAbsence("mobile: lock"), MobileCommand.lockDeviceCommand(duration));
        }
    }

    default public void unlockDevice() {
        String extName = "mobile: unlock";
        try {
            if (!((Boolean)CommandExecutionHelper.executeScript(this.assertExtensionExists("mobile: unlock"), "mobile: isLocked")).booleanValue()) {
                return;
            }
            CommandExecutionHelper.executeScript(this, "mobile: unlock");
        }
        catch (UnsupportedCommandException e) {
            CommandExecutionHelper.execute(this.markExtensionAbsence("mobile: unlock"), MobileCommand.unlockDeviceCommand());
        }
    }

    default public boolean isDeviceLocked() {
        String extName = "mobile: isLocked";
        try {
            return (Boolean)Preconditions.checkNotNull(CommandExecutionHelper.executeScript(this.assertExtensionExists("mobile: isLocked"), "mobile: isLocked"));
        }
        catch (UnsupportedCommandException e) {
            return (Boolean)Preconditions.checkNotNull(CommandExecutionHelper.execute(this.markExtensionAbsence("mobile: isLocked"), MobileCommand.getIsDeviceLockedCommand()));
        }
    }
}

