/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.ios.options.wda;

import io.appium.java_client.ios.options.wda.XcodeCertificate;
import io.appium.java_client.remote.options.BaseOptions;
import io.appium.java_client.remote.options.CanSetCapability;
import java.util.Optional;
import org.openqa.selenium.Capabilities;

public interface SupportsXcodeCertificateOptions<T extends BaseOptions<T>>
extends Capabilities,
CanSetCapability<T> {
    public static final String XCODE_ORG_ID_OPTION = "xcodeOrgId";
    public static final String XCODE_SIGNING_ID_OPTION = "xcodeSigningId";
    public static final String DEFAULT_XCODE_SIGNING_ID = "iPhone Developer";

    default public T setXcodeCertificate(XcodeCertificate cert) {
        String signingId = Optional.ofNullable(cert.getXcodeSigningId()).orElse(DEFAULT_XCODE_SIGNING_ID);
        return (T)this.amend(XCODE_ORG_ID_OPTION, cert.getXcodeOrgId()).amend(XCODE_SIGNING_ID_OPTION, signingId);
    }

    default public Optional<XcodeCertificate> getXcodeCertificate() {
        String orgId = (String)this.getCapability(XCODE_ORG_ID_OPTION);
        String signingId = (String)this.getCapability(XCODE_SIGNING_ID_OPTION);
        return Optional.ofNullable(orgId).map(x -> new XcodeCertificate(orgId, signingId));
    }
}

