/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import com.google.common.base.Preconditions;
import io.appium.java_client.ComparesImages;
import java.awt.image.BufferedImage;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public class ScreenshotState {
    private static final Duration DEFAULT_INTERVAL_MS = Duration.ofMillis(500L);
    private BufferedImage previousScreenshot;
    private final Supplier<BufferedImage> stateProvider;
    private final ComparesImages comparator;
    private Duration comparisonInterval = DEFAULT_INTERVAL_MS;

    public ScreenshotState(ComparesImages comparator, Supplier<BufferedImage> stateProvider) {
        this.comparator = (ComparesImages)Preconditions.checkNotNull((Object)comparator);
        this.stateProvider = stateProvider;
    }

    public ScreenshotState(ComparesImages comparator) {
        this(comparator, null);
    }

    public ScreenshotState remember() {
        this.previousScreenshot = this.stateProvider.get();
        return this;
    }

    public ScreenshotState remember(BufferedImage customInitialState) {
        this.previousScreenshot = (BufferedImage)Preconditions.checkNotNull((Object)customInitialState);
        return this;
    }

    private ScreenshotState checkState(Function<Double, Boolean> checkerFunc, Duration timeout) {
        double score;
        LocalDateTime started = LocalDateTime.now();
        do {
            BufferedImage currentState = this.stateProvider.get();
            score = this.getOverlapScore(Optional.ofNullable(this.previousScreenshot).orElseThrow(() -> new ScreenshotComparisonError("Initial screenshot state is not set. Nothing to compare")), currentState);
            if (checkerFunc.apply(score).booleanValue()) {
                return this;
            }
            try {
                Thread.sleep(this.comparisonInterval.toMillis());
            }
            catch (InterruptedException e) {
                throw new ScreenshotComparisonError(e);
            }
        } while (Duration.between(started, LocalDateTime.now()).compareTo(timeout) <= 0);
        throw new ScreenshotComparisonTimeout(String.format("Screenshot comparison timed out after %s ms. Actual similarity score: %.5f", timeout.toMillis(), score), score);
    }

    public ScreenshotState verifyChanged(Duration timeout, double minScore) {
        return this.checkState(x -> x < minScore, timeout);
    }

    public ScreenshotState verifyNotChanged(Duration timeout, double minScore) {
        return this.checkState(x -> x >= minScore, timeout);
    }

    /*
     * Exception decompiling
     */
    public double getOverlapScore(BufferedImage refImage, BufferedImage tplImage) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Duration getComparisonInterval() {
        return this.comparisonInterval;
    }

    public ScreenshotState setComparisonInterval(Duration comparisonInterval) {
        this.comparisonInterval = comparisonInterval;
        return this;
    }

    public static class ScreenshotComparisonTimeout
    extends RuntimeException {
        private static final long serialVersionUID = 6336247721154252476L;
        private final double currentScore;

        ScreenshotComparisonTimeout(String message, double currentScore) {
            super(message);
            this.currentScore = currentScore;
        }

        public double getCurrentScore() {
            return this.currentScore;
        }
    }

    public static class ScreenshotComparisonError
    extends RuntimeException {
        private static final long serialVersionUID = -7011854909939194466L;

        ScreenshotComparisonError(Throwable reason) {
            super(reason);
        }

        ScreenshotComparisonError(String message) {
            super(message);
        }
    }
}

