/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.internal;

import com.google.common.collect.ImmutableMap;
import io.appium.java_client.MobileElement;
import io.appium.java_client.android.AndroidElement;
import io.appium.java_client.ios.IOSElement;
import io.appium.java_client.windows.WindowsElement;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.remote.RemoteWebElement;

public enum ElementMap {
    ANDROID_UIAUTOMATOR2("UIAutomator2".toLowerCase(), AndroidElement.class),
    SELENDROID("Selendroid".toLowerCase(), AndroidElement.class),
    IOS_XCUI_TEST("XCuiTest".toLowerCase(), IOSElement.class),
    ANDROID_UI_AUTOMATOR("Android".toLowerCase(), AndroidElement.class),
    IOS_UI_AUTOMATION("iOS".toLowerCase(), IOSElement.class),
    WINDOWS("Windows".toLowerCase(), WindowsElement.class);

    private static final Map<String, ElementMap> mobileElementMap;
    private final String platformOrAutomation;
    private final Class<? extends RemoteWebElement> elementClass;

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ElementMap[] elementMapArray = ElementMap.values();
        int n = elementMapArray.length;
        int n2 = 0;
        while (n2 < n) {
            ElementMap e = elementMapArray[n2];
            builder.put((Object)e.getPlatformOrAutomation(), (Object)e);
            ++n2;
        }
        mobileElementMap = builder.build();
    }

    private ElementMap(String platformOrAutomation, Class<? extends MobileElement> elementClass) {
        this.platformOrAutomation = platformOrAutomation;
        this.elementClass = elementClass;
    }

    public String getPlatformOrAutomation() {
        return this.platformOrAutomation;
    }

    public Class<? extends RemoteWebElement> getElementClass() {
        return this.elementClass;
    }

    public static Class<? extends RemoteWebElement> getElementClass(String platform, String automation) {
        if (StringUtils.isBlank((CharSequence)platform) && StringUtils.isBlank((CharSequence)automation)) {
            return RemoteWebElement.class;
        }
        ElementMap element = Optional.ofNullable(mobileElementMap.get(String.valueOf(platform).toLowerCase().trim())).orElseGet(() -> mobileElementMap.get(String.valueOf(automation).toLowerCase().trim()));
        if (element == null) {
            return RemoteWebElement.class;
        }
        return element.getElementClass();
    }
}

