/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.remote;

import com.google.common.base.Strings;
import java.net.URL;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.internal.OkHttpClient;

public class AppiumHttpClientFactory
extends OkHttpClient.Factory {
    private final ConnectionPool pool = new ConnectionPool();
    private final long connectionTimeout;
    private final long readTimeout;

    public AppiumHttpClientFactory() {
        this(Duration.ofMinutes(2L), Duration.ofHours(3L));
    }

    public AppiumHttpClientFactory(Duration connectionTimeout, Duration readTimeout) {
        Objects.requireNonNull(connectionTimeout, "Connection timeout cannot be null");
        Objects.requireNonNull(readTimeout, "Read timeout cannot be null");
        this.connectionTimeout = connectionTimeout.toMillis();
        this.readTimeout = readTimeout.toMillis();
    }

    public HttpClient createClient(URL url) {
        OkHttpClient.Builder client = new OkHttpClient.Builder().connectionPool(this.pool).followRedirects(true).followSslRedirects(true).retryOnConnectionFailure(true).readTimeout(this.readTimeout, TimeUnit.MILLISECONDS).connectTimeout(this.connectionTimeout, TimeUnit.MILLISECONDS);
        String info = url.getUserInfo();
        if (!Strings.isNullOrEmpty((String)info)) {
            String[] parts = info.split(":", 2);
            String user = parts[0];
            String pass = parts.length > 1 ? parts[1] : null;
            String credentials = Credentials.basic((String)user, (String)pass);
            client.authenticator((route, response) -> {
                if (response.request().header("Authorization") != null) {
                    return null;
                }
                return response.request().newBuilder().header("Authorization", credentials).build();
            });
        }
        return new OkHttpClient(client.build(), url);
    }

    public void cleanupIdleClients() {
        this.pool.evictAll();
    }
}

