/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.touch.offset;

import com.google.common.base.Preconditions;
import io.appium.java_client.touch.offset.PointOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.HasIdentity;

public class ElementOption
extends PointOption<ElementOption> {
    private String elementId;

    public static ElementOption element(WebElement element, int x, int y) {
        return new ElementOption().withElement(element).withCoordinates(x, y);
    }

    public static ElementOption element(WebElement element) {
        return new ElementOption().withElement(element);
    }

    @Override
    public ElementOption withCoordinates(int xOffset, int yOffset) {
        this.coordinates = new Point(xOffset, yOffset);
        return this;
    }

    public ElementOption withElement(WebElement element) {
        Preconditions.checkNotNull((Object)element);
        Preconditions.checkArgument((boolean)true, (String)"Element should be an instance of the class which implements org.openqa.selenium.internal.HasIdentity", (Object)HasIdentity.class.isAssignableFrom(element.getClass()));
        this.elementId = ((HasIdentity)HasIdentity.class.cast(element)).getId();
        return this;
    }

    @Override
    protected void verify() {
        Optional.ofNullable(this.elementId).orElseThrow(() -> new IllegalArgumentException("Element should be defined"));
    }

    @Override
    public Map<String, Object> build() {
        this.verify();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("element", this.elementId);
        Optional.ofNullable(this.coordinates).ifPresent(point -> {
            result.put("x", point.x);
            result.put("y", point.y);
        });
        return result;
    }
}

