/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import com.google.common.collect.ImmutableMap;
import io.appium.java_client.AppiumCommandInfo;
import io.appium.java_client.Setting;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.http.HttpMethod;

public class MobileCommand {
    protected static final String RESET = "reset";
    protected static final String GET_STRINGS = "getStrings";
    protected static final String SET_VALUE = "setValue";
    protected static final String PULL_FILE = "pullFile";
    protected static final String PULL_FOLDER = "pullFolder";
    public static final String RUN_APP_IN_BACKGROUND = "runAppInBackground";
    protected static final String PERFORM_TOUCH_ACTION = "performTouchAction";
    protected static final String PERFORM_MULTI_TOUCH = "performMultiTouch";
    protected static final String IS_APP_INSTALLED = "isAppInstalled";
    protected static final String INSTALL_APP = "installApp";
    protected static final String REMOVE_APP = "removeApp";
    protected static final String LAUNCH_APP = "launchApp";
    protected static final String CLOSE_APP = "closeApp";
    protected static final String GET_DEVICE_TIME = "getDeviceTime";
    protected static final String GET_SESSION = "getSession";
    protected static final String GET_PERFORMANCE_DATA = "getPerformanceData";
    protected static final String GET_SUPPORTED_PERFORMANCE_DATA_TYPES = "getSuppportedPerformanceDataTypes";
    protected static final String HIDE_KEYBOARD = "hideKeyboard";
    protected static final String LOCK = "lock";
    protected static final String SHAKE = "shake";
    protected static final String TOUCH_ID = "touchId";
    protected static final String TOUCH_ID_ENROLLMENT = "toggleEnrollTouchId";
    protected static final String CURRENT_ACTIVITY = "currentActivity";
    protected static final String END_TEST_COVERAGE = "endTestCoverage";
    protected static final String GET_DISPLAY_DENSITY = "getDisplayDensity";
    protected static final String GET_NETWORK_CONNECTION = "getNetworkConnection";
    protected static final String GET_SYSTEM_BARS = "getSystemBars";
    protected static final String IS_KEYBOARD_SHOWN = "isKeyboardShown";
    protected static final String IS_LOCKED = "isLocked";
    protected static final String LONG_PRESS_KEY_CODE = "longPressKeyCode";
    protected static final String OPEN_NOTIFICATIONS = "openNotifications";
    protected static final String PRESS_KEY_CODE = "pressKeyCode";
    protected static final String PUSH_FILE = "pushFile";
    protected static final String SET_NETWORK_CONNECTION = "setNetworkConnection";
    protected static final String START_ACTIVITY = "startActivity";
    protected static final String TOGGLE_LOCATION_SERVICES = "toggleLocationServices";
    protected static final String UNLOCK = "unlock";
    protected static final String REPLACE_VALUE = "replaceValue";
    protected static final String GET_SETTINGS = "getSettings";
    protected static final String SET_SETTINGS = "setSettings";
    protected static final String GET_CURRENT_PACKAGE = "getCurrentPackage";
    public static final Map<String, CommandInfo> commandRepository = new HashMap<String, CommandInfo>();

    static {
        commandRepository.put(RESET, MobileCommand.postC("/session/:sessionId/appium/app/reset"));
        commandRepository.put(GET_STRINGS, MobileCommand.postC("/session/:sessionId/appium/app/strings"));
        commandRepository.put(SET_VALUE, MobileCommand.postC("/session/:sessionId/appium/element/:id/value"));
        commandRepository.put(PULL_FILE, MobileCommand.postC("/session/:sessionId/appium/device/pull_file"));
        commandRepository.put(PULL_FOLDER, MobileCommand.postC("/session/:sessionId/appium/device/pull_folder"));
        commandRepository.put(HIDE_KEYBOARD, MobileCommand.postC("/session/:sessionId/appium/device/hide_keyboard"));
        commandRepository.put(RUN_APP_IN_BACKGROUND, MobileCommand.postC("/session/:sessionId/appium/app/background"));
        commandRepository.put(PERFORM_TOUCH_ACTION, MobileCommand.postC("/session/:sessionId/touch/perform"));
        commandRepository.put(PERFORM_MULTI_TOUCH, MobileCommand.postC("/session/:sessionId/touch/multi/perform"));
        commandRepository.put(IS_APP_INSTALLED, MobileCommand.postC("/session/:sessionId/appium/device/app_installed"));
        commandRepository.put(INSTALL_APP, MobileCommand.postC("/session/:sessionId/appium/device/install_app"));
        commandRepository.put(REMOVE_APP, MobileCommand.postC("/session/:sessionId/appium/device/remove_app"));
        commandRepository.put(LAUNCH_APP, MobileCommand.postC("/session/:sessionId/appium/app/launch"));
        commandRepository.put(CLOSE_APP, MobileCommand.postC("/session/:sessionId/appium/app/close"));
        commandRepository.put(LOCK, MobileCommand.postC("/session/:sessionId/appium/device/lock"));
        commandRepository.put(GET_SETTINGS, MobileCommand.getC("/session/:sessionId/appium/settings"));
        commandRepository.put(SET_SETTINGS, MobileCommand.postC("/session/:sessionId/appium/settings"));
        commandRepository.put(GET_DEVICE_TIME, MobileCommand.getC("/session/:sessionId/appium/device/system_time"));
        commandRepository.put(GET_SESSION, MobileCommand.getC("/session/:sessionId/"));
        commandRepository.put(GET_SUPPORTED_PERFORMANCE_DATA_TYPES, MobileCommand.postC("/session/:sessionId/appium/performanceData/types"));
        commandRepository.put(GET_PERFORMANCE_DATA, MobileCommand.postC("/session/:sessionId/appium/getPerformanceData"));
        commandRepository.put(SHAKE, MobileCommand.postC("/session/:sessionId/appium/device/shake"));
        commandRepository.put(TOUCH_ID, MobileCommand.postC("/session/:sessionId/appium/simulator/touch_id"));
        commandRepository.put(TOUCH_ID_ENROLLMENT, MobileCommand.postC("/session/:sessionId/appium/simulator/toggle_touch_id_enrollment"));
        commandRepository.put(CURRENT_ACTIVITY, MobileCommand.getC("/session/:sessionId/appium/device/current_activity"));
        commandRepository.put(END_TEST_COVERAGE, MobileCommand.postC("/session/:sessionId/appium/app/end_test_coverage"));
        commandRepository.put(GET_DISPLAY_DENSITY, MobileCommand.getC("/session/:sessionId/appium/device/display_density"));
        commandRepository.put(GET_NETWORK_CONNECTION, MobileCommand.getC("/session/:sessionId/network_connection"));
        commandRepository.put(GET_SYSTEM_BARS, MobileCommand.getC("/session/:sessionId/appium/device/system_bars"));
        commandRepository.put(IS_KEYBOARD_SHOWN, MobileCommand.getC("/session/:sessionId/appium/device/is_keyboard_shown"));
        commandRepository.put(IS_LOCKED, MobileCommand.postC("/session/:sessionId/appium/device/is_locked"));
        commandRepository.put(LONG_PRESS_KEY_CODE, MobileCommand.postC("/session/:sessionId/appium/device/long_press_keycode"));
        commandRepository.put(OPEN_NOTIFICATIONS, MobileCommand.postC("/session/:sessionId/appium/device/open_notifications"));
        commandRepository.put(PRESS_KEY_CODE, MobileCommand.postC("/session/:sessionId/appium/device/press_keycode"));
        commandRepository.put(PUSH_FILE, MobileCommand.postC("/session/:sessionId/appium/device/push_file"));
        commandRepository.put(SET_NETWORK_CONNECTION, MobileCommand.postC("/session/:sessionId/network_connection"));
        commandRepository.put(START_ACTIVITY, MobileCommand.postC("/session/:sessionId/appium/device/start_activity"));
        commandRepository.put(TOGGLE_LOCATION_SERVICES, MobileCommand.postC("/session/:sessionId/appium/device/toggle_location_services"));
        commandRepository.put(UNLOCK, MobileCommand.postC("/session/:sessionId/appium/device/unlock"));
        commandRepository.put(REPLACE_VALUE, MobileCommand.postC("/session/:sessionId/appium/element/:id/replace_value"));
        commandRepository.put(GET_CURRENT_PACKAGE, MobileCommand.getC("/session/:sessionId/appium/device/current_package"));
    }

    public static AppiumCommandInfo getC(String url) {
        return new AppiumCommandInfo(url, HttpMethod.GET);
    }

    public static AppiumCommandInfo postC(String url) {
        return new AppiumCommandInfo(url, HttpMethod.POST);
    }

    public static AppiumCommandInfo deleteC(String url) {
        return new AppiumCommandInfo(url, HttpMethod.DELETE);
    }

    public static Map.Entry<String, Map<String, ?>> hideKeyboardCommand(String keyName) {
        return new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>(HIDE_KEYBOARD, MobileCommand.prepareArguments("keyName", keyName));
    }

    public static Map.Entry<String, Map<String, ?>> hideKeyboardCommand(String strategy, String keyName) {
        String[] parameters = new String[]{"strategy", "key"};
        Object[] values = new Object[]{strategy, keyName};
        return new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>(HIDE_KEYBOARD, MobileCommand.prepareArguments(parameters, values));
    }

    public static ImmutableMap<String, Object> prepareArguments(String param, Object value) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)param, value);
        return builder.build();
    }

    public static ImmutableMap<String, Object> prepareArguments(String[] params, Object[] values) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int i = 0;
        while (i < params.length) {
            if (!StringUtils.isBlank((CharSequence)params[i]) && values[i] != null) {
                builder.put((Object)params[i], values[i]);
            }
            ++i;
        }
        return builder.build();
    }

    public static Map.Entry<String, Map<String, ?>> pressKeyCodeCommand(int key) {
        return new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>(PRESS_KEY_CODE, MobileCommand.prepareArguments("keycode", key));
    }

    public static Map.Entry<String, Map<String, ?>> pressKeyCodeCommand(int key, Integer metastate) {
        String[] parameters = new String[]{"keycode", "metastate"};
        Object[] values = new Object[]{key, metastate};
        return new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>(PRESS_KEY_CODE, MobileCommand.prepareArguments(parameters, values));
    }

    public static Map.Entry<String, Map<String, ?>> longPressKeyCodeCommand(int key) {
        return new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>(LONG_PRESS_KEY_CODE, MobileCommand.prepareArguments("keycode", key));
    }

    public static Map.Entry<String, Map<String, ?>> longPressKeyCodeCommand(int key, Integer metastate) {
        String[] parameters = new String[]{"keycode", "metastate"};
        Object[] values = new Object[]{key, metastate};
        return new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>(LONG_PRESS_KEY_CODE, MobileCommand.prepareArguments(parameters, values));
    }

    public static Map.Entry<String, Map<String, ?>> lockDeviceCommand(Duration duration) {
        return new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>(LOCK, MobileCommand.prepareArguments("seconds", duration.getSeconds()));
    }

    public static Map.Entry<String, Map<String, ?>> getSettingsCommand() {
        return new AbstractMap.SimpleEntry<String, ImmutableMap>(GET_SETTINGS, ImmutableMap.of());
    }

    public static Map.Entry<String, Map<String, ?>> setSettingsCommand(Setting setting, Object value) {
        return new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>(SET_SETTINGS, MobileCommand.prepareArguments("settings", MobileCommand.prepareArguments(setting.toString(), value)));
    }
}

