/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.android;

import com.google.common.collect.ImmutableMap;
import io.appium.java_client.CommandExecutionHelper;
import io.appium.java_client.ExecutesMethod;
import io.appium.java_client.android.AndroidMobileCommandHelper;
import io.appium.java_client.android.Setting;
import java.time.Duration;
import java.util.Map;
import org.openqa.selenium.remote.Response;

interface HasSettings
extends ExecutesMethod {
    default public void setSetting(Setting setting, Object value) {
        CommandExecutionHelper.execute((ExecutesMethod)this, AndroidMobileCommandHelper.setSettingsCommand(setting, value));
    }

    default public Map<String, Object> getSettings() {
        Map.Entry<String, Map<String, ?>> keyValuePair = AndroidMobileCommandHelper.getSettingsCommand();
        Response response = this.execute(keyValuePair.getKey(), keyValuePair.getValue());
        return ImmutableMap.builder().putAll((Map)Map.class.cast(response.getValue())).build();
    }

    default public void ignoreUnimportantViews(Boolean compress) {
        this.setSetting(Setting.IGNORE_UNIMPORTANT_VIEWS, compress);
    }

    @Deprecated
    default public void configuratorSetWaitForIdleTimeout(int timeout) {
        this.configuratorSetWaitForIdleTimeout(Duration.ofMillis(timeout));
    }

    default public void configuratorSetWaitForIdleTimeout(Duration timeout) {
        this.setSetting(Setting.WAIT_FOR_IDLE_TIMEOUT, timeout.toMillis());
    }

    @Deprecated
    default public void configuratorSetWaitForSelectorTimeout(int timeout) {
        this.configuratorSetWaitForSelectorTimeout(Duration.ofMillis(timeout));
    }

    default public void configuratorSetWaitForSelectorTimeout(Duration timeout) {
        this.setSetting(Setting.WAIT_FOR_SELECTOR_TIMEOUT, timeout.toMillis());
    }

    @Deprecated
    default public void configuratorSetScrollAcknowledgmentTimeout(int timeout) {
        this.configuratorSetScrollAcknowledgmentTimeout(Duration.ofMillis(timeout));
    }

    default public void configuratorSetScrollAcknowledgmentTimeout(Duration timeout) {
        this.setSetting(Setting.WAIT_SCROLL_ACKNOWLEDGMENT_TIMEOUT, timeout.toMillis());
    }

    @Deprecated
    default public void configuratorSetKeyInjectionDelay(int delay) {
        this.configuratorSetKeyInjectionDelay(Duration.ofMillis(delay));
    }

    default public void configuratorSetKeyInjectionDelay(Duration delay) {
        this.setSetting(Setting.KEY_INJECTION_DELAY, delay.toMillis());
    }

    @Deprecated
    default public void configuratorSetActionAcknowledgmentTimeout(int timeout) {
        this.configuratorSetActionAcknowledgmentTimeout(Duration.ofMillis(timeout));
    }

    default public void configuratorSetActionAcknowledgmentTimeout(Duration timeout) {
        this.setSetting(Setting.WAIT_ACTION_ACKNOWLEDGMENT_TIMEOUT, timeout.toMillis());
    }
}

