/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import com.google.common.collect.ImmutableMap;
import io.appium.java_client.CommandExecutionHelper;
import io.appium.java_client.ExecutesMethod;
import io.appium.java_client.MobileCommand;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.Map;

public interface InteractsWithApps
extends ExecutesMethod {
    default public void launchApp() {
        this.execute(MobileCommand.LAUNCH_APP);
    }

    default public void installApp(String appPath) {
        this.execute(MobileCommand.INSTALL_APP, (Map<String, ?>)ImmutableMap.of((Object)"appPath", (Object)appPath));
    }

    default public boolean isAppInstalled(String bundleId) {
        return (Boolean)CommandExecutionHelper.execute((ExecutesMethod)this, new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>(MobileCommand.IS_APP_INSTALLED, MobileCommand.prepareArguments("bundleId", bundleId)));
    }

    default public void resetApp() {
        this.execute(MobileCommand.RESET);
    }

    @Deprecated
    default public void runAppInBackground(int seconds) {
        this.runAppInBackground(Duration.ofSeconds(seconds));
    }

    default public void runAppInBackground(Duration duration) {
        this.execute(MobileCommand.RUN_APP_IN_BACKGROUND, (Map<String, ?>)ImmutableMap.of((Object)"seconds", (Object)duration.getSeconds()));
    }

    default public void removeApp(String bundleId) {
        this.execute(MobileCommand.REMOVE_APP, (Map<String, ?>)ImmutableMap.of((Object)"bundleId", (Object)bundleId));
    }

    default public void closeApp() {
        this.execute(MobileCommand.CLOSE_APP);
    }
}

