/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.android;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.AppiumSetting;
import io.appium.java_client.FindsByAndroidUIAutomator;
import io.appium.java_client.NetworkConnectionSetting;
import io.appium.java_client.android.AndroidDeviceActionShortcuts;
import io.appium.java_client.android.HasNetworkConnection;
import io.appium.java_client.android.PushesFiles;
import io.appium.java_client.android.StartsActivity;
import io.appium.java_client.android.internal.JsonToAndroidElementConverter;
import io.appium.java_client.service.local.AppiumDriverLocalService;
import io.appium.java_client.service.local.AppiumServiceBuilder;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.HttpClient;

public class AndroidDriver<RequiredElementType extends WebElement>
extends AppiumDriver<RequiredElementType>
implements AndroidDeviceActionShortcuts,
HasNetworkConnection,
PushesFiles,
StartsActivity,
FindsByAndroidUIAutomator<RequiredElementType> {
    private static final String ANDROID_PLATFORM = "Android";
    private final String METASTATE_PARAM = "metastate";
    private final String CONNECTION_NAME_PARAM = "name";
    private final String CONNECTION_PARAM_PARAM = "parameters";
    private final String DATA_PARAM = "data";
    private final String INTENT_PARAM = "intent";
    private final String CONNECTION_NAME_VALUE = "network_connection";

    public AndroidDriver(URL remoteAddress, Capabilities desiredCapabilities) {
        super(remoteAddress, AndroidDriver.substituteMobilePlatform(desiredCapabilities, ANDROID_PLATFORM));
        this.setElementConverter(new JsonToAndroidElementConverter(this));
    }

    public AndroidDriver(URL remoteAddress, HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        super(remoteAddress, httpClientFactory, AndroidDriver.substituteMobilePlatform(desiredCapabilities, ANDROID_PLATFORM));
        this.setElementConverter(new JsonToAndroidElementConverter(this));
    }

    public AndroidDriver(AppiumDriverLocalService service, Capabilities desiredCapabilities) {
        super(service, AndroidDriver.substituteMobilePlatform(desiredCapabilities, ANDROID_PLATFORM));
        this.setElementConverter(new JsonToAndroidElementConverter(this));
    }

    public AndroidDriver(AppiumDriverLocalService service, HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        super(service, httpClientFactory, AndroidDriver.substituteMobilePlatform(desiredCapabilities, ANDROID_PLATFORM));
        this.setElementConverter(new JsonToAndroidElementConverter(this));
    }

    public AndroidDriver(AppiumServiceBuilder builder, Capabilities desiredCapabilities) {
        super(builder, AndroidDriver.substituteMobilePlatform(desiredCapabilities, ANDROID_PLATFORM));
        this.setElementConverter(new JsonToAndroidElementConverter(this));
    }

    public AndroidDriver(AppiumServiceBuilder builder, HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        super(builder, httpClientFactory, AndroidDriver.substituteMobilePlatform(desiredCapabilities, ANDROID_PLATFORM));
        this.setElementConverter(new JsonToAndroidElementConverter(this));
    }

    public AndroidDriver(HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        super(httpClientFactory, AndroidDriver.substituteMobilePlatform(desiredCapabilities, ANDROID_PLATFORM));
        this.setElementConverter(new JsonToAndroidElementConverter(this));
    }

    public AndroidDriver(Capabilities desiredCapabilities) {
        super(AndroidDriver.substituteMobilePlatform(desiredCapabilities, ANDROID_PLATFORM));
        this.setElementConverter(new JsonToAndroidElementConverter(this));
    }

    @Override
    public RequiredElementType scrollTo(String text) {
        String uiScrollables = String.valueOf(AndroidDriver.UiScrollable("new UiSelector().descriptionContains(\"" + text + "\")")) + AndroidDriver.UiScrollable("new UiSelector().textContains(\"" + text + "\")");
        return this.findElementByAndroidUIAutomator(uiScrollables);
    }

    @Override
    public RequiredElementType scrollToExact(String text) {
        String uiScrollables = String.valueOf(AndroidDriver.UiScrollable("new UiSelector().description(\"" + text + "\")")) + AndroidDriver.UiScrollable("new UiSelector().text(\"" + text + "\")");
        return this.findElementByAndroidUIAutomator(uiScrollables);
    }

    static String UiScrollable(String uiSelector) {
        return "new UiScrollable(new UiSelector().scrollable(true).instance(0)).scrollIntoView(" + uiSelector + ".instance(0));";
    }

    @Override
    public void pressKeyCode(int key) {
        this.execute("pressKeyCode", (Map)AndroidDriver.getCommandImmutableMap("keycode", key));
    }

    @Override
    public void pressKeyCode(int key, Integer metastate) {
        String[] parameters = new String[]{"keycode", "metastate"};
        Object[] values = new Object[]{key, metastate};
        this.execute("pressKeyCode", (Map)AndroidDriver.getCommandImmutableMap(parameters, values));
    }

    @Override
    public void longPressKeyCode(int key) {
        this.execute("pressKeyCode", (Map)AndroidDriver.getCommandImmutableMap("keycode", key));
    }

    @Override
    public void longPressKeyCode(int key, Integer metastate) {
        String[] parameters = new String[]{"keycode", "metastate"};
        Object[] values = new Object[]{key, metastate};
        this.execute("pressKeyCode", (Map)AndroidDriver.getCommandImmutableMap(parameters, values));
    }

    @Override
    public NetworkConnectionSetting getNetworkConnection() {
        Response response = this.execute("getNetworkConnection");
        return new NetworkConnectionSetting(Integer.parseInt(response.getValue().toString()));
    }

    @Override
    public void setNetworkConnection(NetworkConnectionSetting connection) {
        String[] parameters = new String[]{"name", "parameters"};
        Object[] values = new Object[]{"network_connection", ImmutableMap.of((Object)"type", (Object)connection.value)};
        this.execute("setNetworkConnection", (Map)AndroidDriver.getCommandImmutableMap(parameters, values));
    }

    @Override
    public void pushFile(String remotePath, byte[] base64Data) {
        String[] parameters = new String[]{"path", "data"};
        Object[] values = new Object[]{remotePath, base64Data};
        this.execute("pushFile", (Map)AndroidDriver.getCommandImmutableMap(parameters, values));
    }

    @Override
    public void startActivity(String appPackage, String appActivity, String appWaitPackage, String appWaitActivity, boolean stopApp) throws IllegalArgumentException {
        Preconditions.checkArgument((AndroidDriver._isNotNullOrEmpty(appPackage) && AndroidDriver._isNotNullOrEmpty(appActivity) ? 1 : 0) != 0, (Object)String.format("'%s' and '%s' are required.", "appPackage", "appActivity"));
        appWaitPackage = AndroidDriver._isNotNullOrEmpty(appWaitPackage) ? appWaitPackage : "";
        appWaitActivity = AndroidDriver._isNotNullOrEmpty(appWaitActivity) ? appWaitActivity : "";
        ImmutableMap parameters = ImmutableMap.of((Object)"appPackage", (Object)appPackage, (Object)"appActivity", (Object)appActivity, (Object)"appWaitPackage", (Object)appWaitPackage, (Object)"appWaitActivity", (Object)appWaitActivity, (Object)"dontStopAppOnReset", (Object)(!stopApp ? 1 : 0));
        this.execute("startActivity", (Map)parameters);
    }

    @Override
    public void startActivity(String appPackage, String appActivity, String appWaitPackage, String appWaitActivity) throws IllegalArgumentException {
        this.startActivity(appPackage, appActivity, null, null, true);
    }

    @Override
    public void startActivity(String appPackage, String appActivity) throws IllegalArgumentException {
        this.startActivity(appPackage, appActivity, null, null);
    }

    public void endTestCoverage(String intent, String path) {
        String[] parameters = new String[]{"intent", "path"};
        Object[] values = new Object[]{intent, path};
        this.execute("endTestCoverage", (Map)AndroidDriver.getCommandImmutableMap(parameters, values));
    }

    public String currentActivity() {
        Response response = this.execute("currentActivity");
        return response.getValue().toString();
    }

    public void openNotifications() {
        this.execute("openNotifications");
    }

    public boolean isLocked() {
        Response response = this.execute("isLocked");
        return Boolean.parseBoolean(response.getValue().toString());
    }

    public void toggleLocationServices() {
        this.execute("toggleLocationServices");
    }

    public void ignoreUnimportantViews(Boolean compress) {
        this.setSetting(AppiumSetting.IGNORE_UNIMPORTANT_VIEWS, compress);
    }

    @Override
    public RequiredElementType findElementByAndroidUIAutomator(String using) throws WebDriverException {
        return (RequiredElementType)this.findElement("-android uiautomator", using);
    }

    @Override
    public List<RequiredElementType> findElementsByAndroidUIAutomator(String using) throws WebDriverException {
        return this.findElements("-android uiautomator", using);
    }
}

