/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory;

import io.appium.java_client.pagefactory.ContentType;
import io.appium.java_client.pagefactory.WebDriverUnpackUtility;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.ContextAware;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

class ContentMappedBy
extends By {
    private final Map<ContentType, By> map;
    private static final String NATIVE_APP_PATTERN = "NATIVE_APP";

    public ContentMappedBy(Map<ContentType, By> map) {
        this.map = map;
    }

    private By returnRelevantBy(SearchContext context) {
        WebDriver driver = WebDriverUnpackUtility.unpackWebDriverFromSearchContext(context);
        if (!ContextAware.class.isAssignableFrom(driver.getClass())) {
            return this.map.get((Object)ContentType.HTML);
        }
        ContextAware contextAware = (ContextAware)ContextAware.class.cast(driver);
        String currentContext = contextAware.getContext();
        if (currentContext.contains(NATIVE_APP_PATTERN)) {
            return this.map.get((Object)ContentType.NATIVE);
        }
        return this.map.get((Object)ContentType.HTML);
    }

    public List<WebElement> findElements(SearchContext context) {
        return context.findElements(this.returnRelevantBy(context));
    }

    public String toString() {
        By nativeBy;
        By defaultBy = this.map.get((Object)ContentType.HTML);
        if (defaultBy.equals((Object)(nativeBy = this.map.get((Object)ContentType.NATIVE)))) {
            return defaultBy.toString();
        }
        return "Locator map: \n- native content: \"" + nativeBy.toString() + "\" \n" + "- html content: \"" + defaultBy.toString() + "\"";
    }
}

