/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import io.appium.java_client.AppiumDriver;
import io.appium.java_client.MobileElement;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;

public enum SwipeElementDirection {
    UP{

        @Override
        void swipe(AppiumDriver driver, MobileElement element, int duration) {
            Point p = element.getCenter();
            Point location = element.getLocation();
            Dimension size = element.getSize();
            driver.swipe(p.getX(), location.getY() + size.getHeight(), p.getX(), location.getY(), duration);
        }
    }
    ,
    DOWN{

        @Override
        void swipe(AppiumDriver driver, MobileElement element, int duration) {
            Point p = element.getCenter();
            Point location = element.getLocation();
            Dimension size = element.getSize();
            driver.swipe(p.getX(), location.getY(), p.getX(), location.getY() + size.getHeight(), duration);
        }
    }
    ,
    LEFT{

        @Override
        void swipe(AppiumDriver driver, MobileElement element, int duration) {
            Point p = element.getCenter();
            Point location = element.getLocation();
            Dimension size = element.getSize();
            driver.swipe(location.getX() + size.getWidth(), p.getY(), location.getX(), p.getY(), duration);
        }
    }
    ,
    RIGHT{

        @Override
        void swipe(AppiumDriver driver, MobileElement element, int duration) {
            Point p = element.getCenter();
            Point location = element.getLocation();
            Dimension size = element.getSize();
            driver.swipe(location.getX(), p.getY(), location.getX() + size.getWidth(), p.getY(), duration);
        }
    };


    void swipe(AppiumDriver driver, MobileElement element, int duration) {
    }
}

