/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory;

import io.appium.java_client.MobileElement;
import io.appium.java_client.pagefactory.AndroidFindBy;
import io.appium.java_client.pagefactory.AndroidFindBys;
import io.appium.java_client.pagefactory.AppiumElementLocatorFactory;
import io.appium.java_client.pagefactory.ElementInterceptor;
import io.appium.java_client.pagefactory.ElementListInterceptor;
import io.appium.java_client.pagefactory.ProxyFactory;
import io.appium.java_client.pagefactory.ResetsImplicitlyWaitTimeOut;
import io.appium.java_client.pagefactory.iOSFindBy;
import io.appium.java_client.pagefactory.iOSFindBys;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.support.FindAll;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.FindBys;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.pagefactory.FieldDecorator;

public class AppiumFieldDecorator
implements FieldDecorator,
ResetsImplicitlyWaitTimeOut {
    private final AppiumElementLocatorFactory factory;

    public AppiumFieldDecorator(SearchContext context, long implicitlyWaitTimeOut, TimeUnit timeUnit) {
        this.factory = new AppiumElementLocatorFactory(context, implicitlyWaitTimeOut, timeUnit);
    }

    public AppiumFieldDecorator(SearchContext context) {
        this.factory = new AppiumElementLocatorFactory(context);
    }

    public Object decorate(ClassLoader ignored, Field field) {
        if (!WebElement.class.isAssignableFrom(field.getType()) && !this.isDecoratableList(field)) {
            return null;
        }
        ElementLocator locator = this.factory.createLocator(field);
        if (locator == null) {
            return null;
        }
        if (WebElement.class.isAssignableFrom(field.getType())) {
            return this.proxyForLocator(field, locator);
        }
        if (List.class.isAssignableFrom(field.getType())) {
            return this.proxyForListLocator(locator);
        }
        return null;
    }

    private boolean isDecoratableList(Field field) {
        if (!List.class.isAssignableFrom(field.getType())) {
            return false;
        }
        Type genericType = field.getGenericType();
        if (!(genericType instanceof ParameterizedType)) {
            return false;
        }
        Type listType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
        if (!WebElement.class.equals((Object)listType) && RemoteWebElement.class.equals((Object)listType) && MobileElement.class.equals((Object)listType)) {
            return false;
        }
        return field.getAnnotation(AndroidFindBy.class) != null || field.getAnnotation(iOSFindBy.class) != null || field.getAnnotation(AndroidFindBys.class) != null || field.getAnnotation(iOSFindBys.class) != null || field.getAnnotation(FindBy.class) != null || field.getAnnotation(FindBys.class) != null || field.getAnnotation(FindAll.class) != null;
    }

    private Object proxyForLocator(Field field, ElementLocator locator) {
        Class<Object> type = field.getType();
        if (type.equals(WebElement.class)) {
            type = RemoteWebElement.class;
        }
        ElementInterceptor elementInterceptor = new ElementInterceptor(locator);
        return ProxyFactory.getEnhancedProxy(type, elementInterceptor);
    }

    private List<WebElement> proxyForListLocator(ElementLocator locator) {
        ElementListInterceptor elementInterceptor = new ElementListInterceptor(locator);
        return ProxyFactory.getEnhancedProxy(ArrayList.class, elementInterceptor);
    }

    @Override
    public void resetImplicitlyWaitTimeOut(long timeOut, TimeUnit timeUnit) {
        this.factory.resetImplicitlyWaitTimeOut(timeOut, timeUnit);
    }
}

