/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.types.pagination;

import io.apimatic.core.HttpRequest;
import io.apimatic.core.types.pagination.PaginatedData;
import io.apimatic.core.types.pagination.PaginationDataManager;
import io.apimatic.core.utilities.CoreHelper;

public class CursorPagination
implements PaginationDataManager {
    private final String output;
    private final String input;
    private HttpRequest.Builder nextReqBuilder;

    public CursorPagination(String output, String input) {
        this.output = output;
        this.input = input;
    }

    @Override
    public boolean isValid(PaginatedData<?, ?> paginatedData) {
        this.nextReqBuilder = paginatedData.getLastRequestBuilder();
        String cursorValue = CoreHelper.resolveResponsePointer(this.output, paginatedData.getLastResponseBody(), paginatedData.getLastResponseHeaders());
        if (cursorValue == null) {
            return false;
        }
        boolean[] isUpdated = new boolean[]{false};
        this.nextReqBuilder.updateByReference(this.input, old -> {
            isUpdated[0] = true;
            return cursorValue;
        });
        return isUpdated[0];
    }

    @Override
    public HttpRequest.Builder getNextRequestBuilder() {
        return this.nextReqBuilder;
    }
}

