/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.types;

import com.fasterxml.jackson.databind.JsonNode;
import io.apimatic.core.utilities.CoreHelper;
import io.apimatic.coreinterfaces.http.Context;
import java.io.IOException;

public class CoreApiException
extends Exception {
    private static final long serialVersionUID = 6424174253911720338L;
    private Context httpContext;

    public CoreApiException(String reason) {
        super(reason);
    }

    public CoreApiException(String reason, Context context) {
        super(reason);
        this.httpContext = context;
        if (context == null || context.getResponse() == null || context.getResponse().getRawBody() == null) {
            return;
        }
        try {
            JsonNode jsonNode = CoreHelper.getMapper().readTree(context.getResponse().getRawBody());
            if (!this.getClass().equals(CoreApiException.class)) {
                CoreHelper.getMapper().readerForUpdating((Object)this).readValue(jsonNode);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getResponseCode() {
        if (this.httpContext == null || this.httpContext.getResponse() == null) {
            return -1;
        }
        return this.httpContext.getResponse().getStatusCode();
    }

    public Context getHttpContext() {
        return this.httpContext;
    }
}

