/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.utilities;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import io.apimatic.core.utilities.CoreHelper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.stream.Collectors;

public final class TestHelper {
    private static final int BASE_16 = 16;
    private static final int TO_EXTRACT_HEXADECIMAL = 256;
    private static final int HEXADECIMAL_CONVERTOR = 255;
    private static final int BUFFER_SIZE = 1024;
    public static final String NULL_STRING = "b9cb2f80-1b64-43ee-a6da-71f7ef686fa9";

    private TestHelper() {
    }

    public static <T> String prepareForComparison(String json, TypeReference<T> typeReference) throws JsonProcessingException, IOException {
        return CoreHelper.serialize(CoreHelper.deserialize(json, typeReference));
    }

    public static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is);
        String str = s.useDelimiter("\\A").hasNext() ? s.next() : "";
        s.close();
        return str;
    }

    public static boolean isProperSubsetOf(String leftObject, String rightObject, boolean checkValues, boolean allowExtra, boolean isOrdered) throws IOException {
        JsonNode leftNode = CoreHelper.getMapper().readTree(leftObject);
        if (leftNode.isObject()) {
            return TestHelper.isJsonObjectProperSubsetOf(leftObject, rightObject, checkValues, allowExtra, isOrdered);
        }
        if (leftNode.isArray()) {
            if (leftNode.get(0).isArray()) {
                return TestHelper.isArrayOfArrayOfJsonObjectsProperSubsetOf(leftObject, rightObject, checkValues, allowExtra, isOrdered);
            }
            return TestHelper.isArrayOfJsonObjectsProperSubsetOf(leftObject, rightObject, checkValues, allowExtra, isOrdered);
        }
        throw new IOException("Unable to find suitable method call");
    }

    private static boolean isProperSubsetOf(Map<String, Object> leftTree, Map<String, Object> rightTree, boolean checkValues, boolean allowExtra, boolean isOrdered) {
        for (String key : leftTree.keySet()) {
            Object leftVal = leftTree.get(key);
            Object rightVal = rightTree.get(key);
            if (!rightTree.containsKey(key)) {
                return false;
            }
            if (leftVal instanceof Map) {
                if (rightVal instanceof Map) {
                    if (TestHelper.isProperSubsetOf((Map)leftVal, (Map)rightVal, checkValues, allowExtra, isOrdered)) continue;
                    return false;
                }
                return false;
            }
            if (!checkValues) continue;
            if (leftVal == null) {
                if (rightVal == null) continue;
                return false;
            }
            if (leftVal instanceof List) {
                if (!(rightVal instanceof List)) {
                    return false;
                }
                List leftList = (List)leftVal;
                List rightList = (List)rightVal;
                if (leftList.isEmpty() && rightList.isEmpty()) continue;
                boolean isContentDataTypeSame = leftList.stream().allMatch(rightList.get(0).getClass()::isInstance);
                if (!isContentDataTypeSame) {
                    List<Object> remainingRightList;
                    List<LinkedHashMap<String, Object>> rightListOfMap;
                    List<LinkedHashMap<String, Object>> leftListOfMap = leftList.stream().filter(x -> x instanceof Map).collect(Collectors.toList());
                    if (!TestHelper.isArrayOfJsonObjectsProperSubsetOf(leftListOfMap, rightListOfMap = rightList.stream().filter(x -> x instanceof Map).collect(Collectors.toList()), checkValues, allowExtra, isOrdered)) {
                        return false;
                    }
                    List<Object> remainingLeftList = leftList.stream().filter(x -> !leftListOfMap.contains(x)).collect(Collectors.toList());
                    if (TestHelper.isListProperSubsetOf(remainingLeftList, remainingRightList = rightList.stream().filter(x -> !rightListOfMap.contains(x)).collect(Collectors.toList()), allowExtra, isOrdered)) continue;
                    return false;
                }
                if (!(leftList.get(0) instanceof Map & isContentDataTypeSame ? !TestHelper.isArrayOfJsonObjectsProperSubsetOf((List)leftVal, (List)rightVal, checkValues, allowExtra, isOrdered) : !TestHelper.isListProperSubsetOf((List)leftVal, (List)rightVal, allowExtra, isOrdered))) continue;
                return false;
            }
            if (leftVal.equals(rightTree.get(key)) || leftVal == NULL_STRING) continue;
            return false;
        }
        return true;
    }

    public static boolean isJsonObjectProperSubsetOf(String leftObject, String rightObject, boolean checkValues, boolean allowExtra, boolean isOrdered) throws IOException {
        return TestHelper.isProperSubsetOf(CoreHelper.deserialize(leftObject), CoreHelper.deserialize(rightObject), checkValues, allowExtra, isOrdered);
    }

    public static boolean isArrayOfArrayOfJsonObjectsProperSubsetOf(String leftObject, String rightObject, boolean checkValues, boolean allowExtra, boolean isOrdered) throws IOException {
        LinkedList obj = new LinkedList();
        LinkedList left = (LinkedList)CoreHelper.deserialize(leftObject, obj.getClass());
        LinkedList right = (LinkedList)CoreHelper.deserialize(rightObject, obj.getClass());
        return TestHelper.isArrayOfArrayOfJsonObjectsProperSubsetOf(left, right, checkValues, allowExtra, isOrdered);
    }

    private static boolean isArrayOfArrayOfJsonObjectsProperSubsetOf(List<LinkedList<LinkedHashMap<String, Object>>> left, List<LinkedList<LinkedHashMap<String, Object>>> right, boolean checkValues, boolean allowExtra, boolean isOrdered) {
        if (!allowExtra && left.size() != right.size()) {
            return false;
        }
        Iterator<LinkedList<LinkedHashMap<String, Object>>> leftIter = left.iterator();
        Iterator<LinkedList<LinkedHashMap<String, Object>>> rightIter = right.iterator();
        while (leftIter.hasNext()) {
            List leftTree = leftIter.next();
            boolean found = false;
            if (!isOrdered) {
                rightIter = right.iterator();
            }
            while (rightIter.hasNext()) {
                if (!TestHelper.isArrayOfJsonObjectsProperSubsetOf(leftTree, (List<LinkedHashMap<String, Object>>)rightIter.next(), checkValues, allowExtra, isOrdered)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static boolean isArrayOfJsonObjectsProperSubsetOf(String leftObject, String rightObject, boolean checkValues, boolean allowExtra, boolean isOrdered) throws IOException {
        LinkedList obj = new LinkedList();
        LinkedList left = (LinkedList)CoreHelper.deserialize(leftObject, obj.getClass());
        LinkedList right = (LinkedList)CoreHelper.deserialize(rightObject, obj.getClass());
        boolean containsMap = true;
        for (int i = 0; i < left.size(); ++i) {
            if (left.get(i) instanceof Map) continue;
            containsMap = false;
            break;
        }
        if (!containsMap) {
            int i;
            LinkedList<Object> leftList = new LinkedList<Object>();
            LinkedList<Object> rightList = new LinkedList<Object>();
            for (i = 0; i < left.size(); ++i) {
                if (left.get(i) instanceof Map) continue;
                leftList.add(left.get(i));
            }
            for (i = 0; i < right.size(); ++i) {
                if (right.get(i) instanceof Map) continue;
                rightList.add(right.get(i));
            }
            left.removeAll(leftList);
            right.removeAll(rightList);
            if (!TestHelper.isListProperSubsetOf(leftList, rightList, allowExtra, isOrdered)) {
                return false;
            }
        }
        return TestHelper.isArrayOfJsonObjectsProperSubsetOf(left, right, checkValues, allowExtra, isOrdered);
    }

    private static boolean isArrayOfJsonObjectsProperSubsetOf(List<LinkedHashMap<String, Object>> left, List<LinkedHashMap<String, Object>> right, boolean checkValues, boolean allowExtra, boolean isOrdered) {
        if (!allowExtra && left.size() != right.size()) {
            return false;
        }
        Iterator<LinkedHashMap<String, Object>> leftIter = left.iterator();
        Iterator<LinkedHashMap<String, Object>> rightIter = right.iterator();
        while (leftIter.hasNext()) {
            LinkedHashMap<String, Object> leftTree = leftIter.next();
            boolean found = false;
            if (!isOrdered) {
                rightIter = right.iterator();
            }
            while (rightIter.hasNext()) {
                if (!TestHelper.isProperSubsetOf(leftTree, (Map<String, Object>)rightIter.next(), checkValues, allowExtra, isOrdered)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private static boolean isListProperSubsetOf(List<Object> leftList, List<Object> rightList, boolean allowExtra, boolean isOrdered) {
        if (isOrdered && !allowExtra) {
            return rightList.equals(leftList);
        }
        if (isOrdered && allowExtra) {
            return rightList.subList(0, leftList.size()).equals(leftList);
        }
        if (!isOrdered && !allowExtra) {
            return leftList.size() == rightList.size() && rightList.containsAll(leftList);
        }
        if (!isOrdered && allowExtra) {
            return rightList.containsAll(leftList);
        }
        return true;
    }

    public static boolean areHeadersProperSubsetOf(Map<String, String> leftTree, Map<String, String> rightTree, boolean checkValues) {
        TreeMap<String, Object> l = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        TreeMap<String, Object> r = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        l.putAll(leftTree);
        r.putAll(rightTree);
        return TestHelper.isProperSubsetOf(l, r, checkValues, false, false);
    }

    private static boolean isSameInputStream(InputStream input1, InputStream input2) throws IOException {
        int ch2;
        input1 = new BufferedInputStream(input1);
        if (!(input2 instanceof BufferedInputStream)) {
            input2 = new BufferedInputStream(input2);
        }
        int ch = input1.read();
        while (ch != -1) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }

    public static boolean isSameAsFile(String file, InputStream input) throws FileNotFoundException, IOException {
        return TestHelper.isSameInputStream(new FileInputStream(TestHelper.getFile(file)), input);
    }

    public static File getFile(String urlString) throws IOException {
        String filename = "sdk_tests" + TestHelper.toSha1(urlString) + ".tmp";
        String tmpPath = System.getProperty("java.io.tmpdir");
        File f = new File(tmpPath, filename);
        if (!f.exists()) {
            int len;
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            InputStream in = connection.getInputStream();
            f.createNewFile();
            FileOutputStream out = new FileOutputStream(f);
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            out.close();
            in.close();
            f.deleteOnExit();
        }
        return f;
    }

    private static String toSha1(String convertme) {
        byte[] data = convertme.getBytes();
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return TestHelper.byteArrayToHexString(md.digest(data));
    }

    private static String byteArrayToHexString(byte[] b) {
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }

    public static boolean equalsBigDecimalList(List<BigDecimal> actual, List<BigDecimal> expected) {
        if (actual.size() != expected.size()) {
            return false;
        }
        for (int i = 0; i < actual.size(); ++i) {
            if (actual.get(i).compareTo(expected.get(i)) == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean containsBigDecimalList(List<BigDecimal> actual, List<BigDecimal> expected) {
        for (BigDecimal expectedValue : expected) {
            boolean found = false;
            for (BigDecimal actualValue : actual) {
                if (actualValue.compareTo(expectedValue) != 0) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

