/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.types.pagination;

import io.apimatic.core.ApiCall;
import io.apimatic.core.HttpRequest;
import io.apimatic.core.types.CoreApiException;
import io.apimatic.core.types.pagination.CheckedSupplier;
import io.apimatic.core.types.pagination.PageWrapper;
import io.apimatic.core.types.pagination.PaginationStrategy;
import io.apimatic.coreinterfaces.http.response.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class PaginatedData<I, P, R, E extends CoreApiException> {
    private final ApiCall<R, E> firstApiCall;
    private final Function<PageWrapper<I, R>, P> pageCreator;
    private final Function<R, List<I>> itemsCreator;
    private final PaginationStrategy[] strategies;
    private int itemIndex = 0;
    private final List<CheckedSupplier<I, E>> items = new ArrayList<CheckedSupplier<I, E>>();
    private CheckedSupplier<P, E> page = null;
    private ApiCall<R, E> apiCall;
    private PaginationStrategy lockedStrategy;
    private boolean canLockStrategy = false;
    private boolean dataClosed = false;

    public PaginatedData(ApiCall<R, E> apiCall, Function<PageWrapper<I, R>, P> pageCreator, Function<R, List<I>> itemsCreator, PaginationStrategy ... strategies) {
        this.firstApiCall = apiCall;
        this.pageCreator = pageCreator;
        this.itemsCreator = itemsCreator;
        this.strategies = strategies;
        this.apiCall = apiCall;
    }

    public HttpRequest.Builder getRequestBuilder() {
        return this.apiCall.getRequestBuilder();
    }

    public Response getResponse() {
        return this.apiCall.getResponse();
    }

    public int getPageSize() {
        return this.items.size();
    }

    public <T> List<T> getItems(Function<CheckedSupplier<I, E>, T> itemSupplier) {
        ArrayList<T> convertedItems = new ArrayList<T>();
        for (CheckedSupplier<I, E> i : this.items) {
            convertedItems.add(itemSupplier.apply(i));
        }
        return convertedItems;
    }

    public <T> T getPage(Function<CheckedSupplier<P, E>, T> pageSupplier) {
        if (this.page == null) {
            return null;
        }
        return pageSupplier.apply(this.page);
    }

    public <T> Iterator<T> items(final Function<CheckedSupplier<I, E>, T> itemSupplier) {
        final PaginatedData<I, P, R, E> paginatedData = this.copy();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                if (paginatedData.itemIndex < paginatedData.items.size()) {
                    return true;
                }
                return paginatedData.fetchNextPage();
            }

            @Override
            public T next() {
                if (paginatedData.itemIndex == paginatedData.items.size()) {
                    throw new NoSuchElementException("No more items available.");
                }
                return itemSupplier.apply(paginatedData.items.get(paginatedData.itemIndex++));
            }
        };
    }

    public <T> Iterator<T> pages(final Function<CheckedSupplier<P, E>, T> pageSupplier) {
        final PaginatedData<I, P, R, E> paginatedData = this.copy();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                if (paginatedData.page != null) {
                    return true;
                }
                return paginatedData.fetchNextPage();
            }

            @Override
            public T next() {
                if (paginatedData.page == null) {
                    throw new NoSuchElementException("No more pages available.");
                }
                Object convertedPage = pageSupplier.apply(paginatedData.page);
                paginatedData.page = null;
                return convertedPage;
            }
        };
    }

    public PaginatedData<I, P, R, E> copy() {
        return new PaginatedData<I, P, R, E>(this.firstApiCall, this.pageCreator, this.itemsCreator, this.strategies);
    }

    public CompletableFuture<Boolean> fetchNextPageAsync() {
        if (this.dataClosed) {
            return CompletableFuture.completedFuture(false);
        }
        for (PaginationStrategy strategy : this.getStrategies()) {
            HttpRequest.Builder requestBuilder = strategy.apply(this);
            if (requestBuilder == null) continue;
            ApiCall<R, E> newApiCall = this.apiCall.toBuilder().requestBuilder(requestBuilder).build();
            return ((CompletableFuture)newApiCall.executeAsync().thenApply(result -> this.updateWith(newApiCall, result, strategy))).exceptionally(ex -> this.updateAsFailed(ex.getCause()));
        }
        return CompletableFuture.completedFuture(false);
    }

    private boolean fetchNextPage() {
        if (this.dataClosed) {
            return false;
        }
        for (PaginationStrategy strategy : this.getStrategies()) {
            HttpRequest.Builder requestBuilder = strategy.apply(this);
            if (requestBuilder == null) continue;
            try {
                ApiCall<R, E> newApiCall = this.apiCall.toBuilder().requestBuilder(requestBuilder).build();
                R pageUnWrapped = newApiCall.execute();
                return this.updateWith(newApiCall, pageUnWrapped, strategy);
            }
            catch (CoreApiException | IOException exp) {
                return this.updateAsFailed(exp);
            }
        }
        return false;
    }

    private PaginationStrategy[] getStrategies() {
        if (this.lockedStrategy == null) {
            return this.strategies;
        }
        return new PaginationStrategy[]{this.lockedStrategy};
    }

    private boolean updateWith(ApiCall<R, E> apiCall, R pageUnWrapped, PaginationStrategy strategy) {
        this.itemIndex = 0;
        this.items.clear();
        this.page = null;
        if (pageUnWrapped == null) {
            return false;
        }
        List<I> itemsUnWrapped = this.itemsCreator.apply(pageUnWrapped);
        if (itemsUnWrapped == null || itemsUnWrapped.isEmpty()) {
            return false;
        }
        this.apiCall = apiCall;
        PageWrapper<I, R> pageWrapper = PageWrapper.create(apiCall.getResponse(), pageUnWrapped, itemsUnWrapped, strategy);
        this.page = CheckedSupplier.create(this.pageCreator.apply(pageWrapper));
        itemsUnWrapped.forEach(i -> this.items.add(CheckedSupplier.create(i)));
        if (this.canLockStrategy) {
            this.lockedStrategy = strategy;
        } else {
            this.canLockStrategy = true;
        }
        return true;
    }

    private boolean updateAsFailed(Throwable exp) {
        this.page = CheckedSupplier.createError(exp);
        this.itemIndex = 0;
        this.items.clear();
        this.items.add(CheckedSupplier.createError(exp));
        this.dataClosed = true;
        return true;
    }
}

