/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.types;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.apimatic.core.utilities.LocalDateTimeHelper;
import io.apimatic.core.utilities.ZonedDateTimeHelper;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class OptionalNullable<T> {
    private T value;

    private OptionalNullable(T value) {
        this.value = value;
    }

    public String toString() {
        return "" + this.value;
    }

    public static <T> OptionalNullable<T> of(T value) {
        return new OptionalNullable<T>(value);
    }

    public static <T> T getFrom(OptionalNullable<T> optionalNullable) {
        return optionalNullable == null ? null : (T)optionalNullable.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof OptionalNullable) {
            return Objects.equals(((OptionalNullable)obj).value, this.value);
        }
        return Objects.equals(obj, this.value);
    }

    public static class ZonedRfc8601DateTimeSerializer
    extends DateSerializer<String> {
        @Override
        public String extractSimpleData(Object data) {
            return ZonedDateTimeHelper.toRfc8601DateTime((ZonedDateTime)data);
        }

        @Override
        public List<String> extractListData(Object data) {
            return ZonedDateTimeHelper.toRfc8601DateTime((List)data);
        }

        @Override
        public Map<String, String> extractMapData(Object data) {
            return ZonedDateTimeHelper.toRfc8601DateTime((Map)data);
        }
    }

    public static class ZonedRfc1123DateTimeSerializer
    extends DateSerializer<String> {
        @Override
        public String extractSimpleData(Object data) {
            return ZonedDateTimeHelper.toRfc1123DateTime((ZonedDateTime)data);
        }

        @Override
        public List<String> extractListData(Object data) {
            return ZonedDateTimeHelper.toRfc1123DateTime((List)data);
        }

        @Override
        public Map<String, String> extractMapData(Object data) {
            return ZonedDateTimeHelper.toRfc1123DateTime((Map)data);
        }
    }

    public static class ZonedUnixTimestampSerializer
    extends DateSerializer<Long> {
        @Override
        public Long extractSimpleData(Object data) {
            return ZonedDateTimeHelper.toUnixTimestampLong((ZonedDateTime)data);
        }

        @Override
        public List<Long> extractListData(Object data) {
            return ZonedDateTimeHelper.toUnixTimestampLong((List)data);
        }

        @Override
        public Map<String, Long> extractMapData(Object data) {
            return ZonedDateTimeHelper.toUnixTimestampLong((Map)data);
        }
    }

    public static class Rfc8601DateTimeSerializer
    extends DateSerializer<String> {
        @Override
        public String extractSimpleData(Object data) {
            return LocalDateTimeHelper.toRfc8601DateTime((LocalDateTime)data);
        }

        @Override
        public List<String> extractListData(Object data) {
            return LocalDateTimeHelper.toRfc8601DateTime((List)data);
        }

        @Override
        public Map<String, String> extractMapData(Object data) {
            return LocalDateTimeHelper.toRfc8601DateTime((Map)data);
        }
    }

    public static class Rfc1123DateTimeSerializer
    extends DateSerializer<String> {
        @Override
        public String extractSimpleData(Object data) {
            return LocalDateTimeHelper.toRfc1123DateTime((LocalDateTime)data);
        }

        @Override
        public List<String> extractListData(Object data) {
            return LocalDateTimeHelper.toRfc1123DateTime((List)data);
        }

        @Override
        public Map<String, String> extractMapData(Object data) {
            return LocalDateTimeHelper.toRfc1123DateTime((Map)data);
        }
    }

    public static class UnixTimestampSerializer
    extends DateSerializer<Long> {
        @Override
        public Long extractSimpleData(Object data) {
            return LocalDateTimeHelper.toUnixTimestampLong((LocalDateTime)data);
        }

        @Override
        public List<Long> extractListData(Object data) {
            return LocalDateTimeHelper.toUnixTimestampLong((List)data);
        }

        @Override
        public Map<String, Long> extractMapData(Object data) {
            return LocalDateTimeHelper.toUnixTimestampLong((Map)data);
        }
    }

    public static class SimpleDateSerializer
    extends DateSerializer<String> {
        @Override
        public String extractSimpleData(Object data) {
            return LocalDateTimeHelper.toSimpleDate((LocalDate)data);
        }

        @Override
        public List<String> extractListData(Object data) {
            return LocalDateTimeHelper.toSimpleDate((List)data);
        }

        @Override
        public Map<String, String> extractMapData(Object data) {
            return LocalDateTimeHelper.toSimpleDate((Map)data);
        }
    }

    private static abstract class DateSerializer<M>
    extends Serializer {
        private DateSerializer() {
        }

        @Override
        protected Object extractData(Object data) {
            if (data instanceof List) {
                return this.extractListData((List)data);
            }
            if (data instanceof Map) {
                return this.extractMapData((Map)data);
            }
            return this.extractSimpleData(data);
        }

        public abstract M extractSimpleData(Object var1);

        public abstract List<M> extractListData(Object var1);

        public abstract Map<String, M> extractMapData(Object var1);
    }

    public static class Serializer
    extends JsonSerializer<OptionalNullable<Object>> {
        protected Object extractData(Object data) {
            return data;
        }

        public void serialize(OptionalNullable<Object> object, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeObject(this.extractData(((OptionalNullable)object).value));
        }
    }
}

