/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.authentication.multiple;

import io.apimatic.coreinterfaces.authentication.Authentication;
import io.apimatic.coreinterfaces.http.request.Request;
import java.util.ArrayList;
import java.util.List;

public abstract class AuthGroup
extends Authentication {
    private List<Authentication> authParticipants;
    private List<String> errorMessages;

    public AuthGroup(List<Authentication> authParticipants) {
        if (authParticipants == null) {
            throw new IllegalArgumentException("Auth Participants can not be null.");
        }
        this.authParticipants = authParticipants;
        this.errorMessages = new ArrayList<String>();
    }

    public Request apply(Request httpRequest) {
        for (Authentication participant : this.authParticipants) {
            if (!participant.isValid()) continue;
            httpRequest = participant.apply(httpRequest);
        }
        return httpRequest;
    }

    protected List<String> getErrorMessages() {
        return this.errorMessages;
    }

    protected List<Authentication> getAuthParticipants() {
        return this.authParticipants;
    }
}

