/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.authentication;

import io.apimatic.core.authentication.multiple.And;
import io.apimatic.core.authentication.multiple.Or;
import io.apimatic.core.authentication.multiple.Single;
import io.apimatic.coreinterfaces.authentication.Authentication;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class AuthBuilder {
    private static final String AND = "AND";
    private static final String OR = "OR";
    private Map<String, List<AuthBuilder>> authBuilders = new HashMap<String, List<AuthBuilder>>();
    private List<String> authKeys;

    public AuthBuilder() {
        this.authBuilders.put(AND, new ArrayList());
        this.authBuilders.put(OR, new ArrayList());
        this.authKeys = new ArrayList<String>();
    }

    public AuthBuilder add(String authKey) {
        this.authKeys.add(authKey);
        return this;
    }

    public AuthBuilder and(Consumer<AuthBuilder> action) {
        AuthBuilder authBuilder = new AuthBuilder();
        action.accept(authBuilder);
        this.authBuilders.get(AND).add(authBuilder);
        return this;
    }

    public AuthBuilder or(Consumer<AuthBuilder> action) {
        AuthBuilder authBuilder = new AuthBuilder();
        action.accept(authBuilder);
        this.authBuilders.get(OR).add(authBuilder);
        return this;
    }

    public Authentication build(Map<String, Authentication> authManagers) {
        if (authManagers == null || authManagers.isEmpty()) {
            return null;
        }
        if (this.authBuilders.get(AND).isEmpty() && this.authBuilders.get(OR).isEmpty() && this.authKeys.isEmpty()) {
            return null;
        }
        Authentication mappedAuth = null;
        if (this.authBuilders.get(AND).isEmpty() && this.authBuilders.get(OR).isEmpty() && !this.authKeys.isEmpty()) {
            mappedAuth = new Single(authManagers.get(this.authKeys.get(0)));
            return mappedAuth;
        }
        for (AuthBuilder authBuilder : this.authBuilders.get(AND)) {
            mappedAuth = new And(authBuilder.buildAuthGroup(authManagers));
        }
        for (AuthBuilder authBuilder : this.authBuilders.get(OR)) {
            mappedAuth = new Or(authBuilder.buildAuthGroup(authManagers));
        }
        return mappedAuth;
    }

    private List<Authentication> buildAuthGroup(Map<String, Authentication> authManagers) {
        ArrayList<Authentication> auths = new ArrayList<Authentication>();
        this.authKeys.forEach(authKey -> {
            if (authManagers.containsKey(authKey)) {
                auths.add(new Single((Authentication)authManagers.get(authKey)));
            }
        });
        this.authBuilders.get(AND).forEach(authBuilder -> auths.add(new And(authBuilder.buildAuthGroup(authManagers))));
        this.authBuilders.get(OR).forEach(authBuilder -> auths.add(new Or(authBuilder.buildAuthGroup(authManagers))));
        return auths;
    }

    public AuthBuilder copy() {
        AuthBuilder copy = new AuthBuilder();
        copy.authKeys = new ArrayList<String>(this.authKeys);
        for (Map.Entry<String, List<AuthBuilder>> entry : this.authBuilders.entrySet()) {
            ArrayList<AuthBuilder> copiedList = new ArrayList<AuthBuilder>();
            for (AuthBuilder builder : entry.getValue()) {
                copiedList.add(builder.copy());
            }
            copy.authBuilders.put(entry.getKey(), copiedList);
        }
        return copy;
    }
}

