/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core;

import io.apimatic.core.types.CoreApiException;
import io.apimatic.core.utilities.CoreHelper;
import io.apimatic.coreinterfaces.http.Context;
import io.apimatic.coreinterfaces.http.HttpHeaders;
import io.apimatic.coreinterfaces.http.response.Response;
import io.apimatic.coreinterfaces.type.functional.ExceptionCreator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ErrorCase<ExceptionType extends CoreApiException> {
    public static final String DEFAULT = "DEFAULT";
    private String reason;
    private boolean isErrorTemplate;
    private ExceptionCreator<ExceptionType> exceptionCreator;

    private ErrorCase(String reason, ExceptionCreator<ExceptionType> exceptionCreator, boolean isErrorTemplate) {
        this.reason = reason;
        this.exceptionCreator = exceptionCreator;
        this.isErrorTemplate = isErrorTemplate;
    }

    public void throwException(Context httpContext) throws ExceptionType {
        throw (CoreApiException)this.exceptionCreator.apply(this.getReason(httpContext.getResponse()), httpContext);
    }

    public static <ExceptionType extends CoreApiException> ErrorCase<ExceptionType> setReason(String reason, ExceptionCreator<ExceptionType> exceptionCreator) {
        ErrorCase<ExceptionType> errorCase = new ErrorCase<ExceptionType>(reason, exceptionCreator, false);
        return errorCase;
    }

    public static <ExceptionType extends CoreApiException> ErrorCase<ExceptionType> setTemplate(String reason, ExceptionCreator<ExceptionType> exceptionCreator) {
        return new ErrorCase<ExceptionType>(reason, exceptionCreator, true);
    }

    private String getReason(Response response) {
        if (!this.isErrorTemplate) {
            return this.reason;
        }
        String resolvedReason = this.replaceStatusCodeFromTemplate(response.getStatusCode(), this.reason);
        resolvedReason = this.replaceHeadersFromTemplate(response.getHeaders(), resolvedReason);
        resolvedReason = this.replaceBodyFromTemplate(response.getBody(), resolvedReason);
        return resolvedReason;
    }

    private String replaceStatusCodeFromTemplate(int statusCode, String reason) {
        StringBuilder formatter = new StringBuilder(reason);
        Matcher matcher = Pattern.compile("\\{(.*?)\\}").matcher(reason);
        while (matcher.find()) {
            String formatKey;
            int index;
            String key = matcher.group(1);
            if (!key.equals("$statusCode") || (index = formatter.indexOf(formatKey = String.format("{%s}", key))) == -1) continue;
            formatter.replace(index, index + formatKey.length(), "" + statusCode);
        }
        return formatter.toString();
    }

    private String replaceHeadersFromTemplate(HttpHeaders headers, String reason) {
        StringBuilder formatter = new StringBuilder(reason);
        Matcher matcher = Pattern.compile("\\{(.*?)\\}").matcher(reason);
        while (matcher.find()) {
            String key = matcher.group(1);
            String pointerKey = key;
            if (!pointerKey.startsWith("$response.header.")) continue;
            pointerKey = pointerKey.replace("$response.header.", "");
            String formatKey = String.format("{%s}", key);
            int index = formatter.indexOf(formatKey);
            pointerKey = pointerKey.toLowerCase();
            if (index == -1) continue;
            formatter.replace(index, index + formatKey.length(), "" + (headers.has(pointerKey) ? headers.value(pointerKey) : ""));
        }
        return formatter.toString();
    }

    private String replaceBodyFromTemplate(String responseBody, String reason) {
        StringBuilder formatter = new StringBuilder(reason);
        Matcher matcher = Pattern.compile("\\{(.*?)\\}").matcher(reason);
        while (matcher.find()) {
            String key;
            String pointerKey = key = matcher.group(1);
            this.replaceBodyString(responseBody, formatter, key, pointerKey);
        }
        return formatter.toString().replace("\"", "");
    }

    private void replaceBodyString(String responseBody, StringBuilder formatter, String key, String pointerKey) {
        String formatKey;
        int index;
        if (pointerKey.startsWith("$response.body") && (index = formatter.indexOf(formatKey = String.format("{%s}", key))) != -1) {
            String toReplaceString = this.extractReplacementString(responseBody, pointerKey);
            formatter.replace(index, index + formatKey.length(), toReplaceString);
        }
    }

    private String extractReplacementString(String responseBody, String pointerKey) {
        if (pointerKey.contains("#")) {
            String pointerValue = CoreHelper.getValueFromJson(pointerKey = pointerKey.replace("$response.body#", ""), responseBody);
            if (pointerValue != null) {
                return pointerValue;
            }
            return "";
        }
        if (responseBody != null && !responseBody.isEmpty()) {
            return responseBody;
        }
        return "";
    }
}

