/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.utilities;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.apimatic.core.utilities.DateHelper;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class LocalDateTimeHelper
extends DateHelper {
    private static final DateTimeFormatter RFC1123_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss z");

    public static LocalDateTime fromUnixTimestamp(Long date) {
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(date), ZoneId.systemDefault());
    }

    public static LocalDateTime fromUnixTimestamp(String date) {
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(Long.parseLong(date)), ZoneId.systemDefault());
    }

    public static String toUnixTimestamp(LocalDateTime value) {
        return value == null ? null : Long.toString(LocalDateTimeHelper.toUnixTimestampLong(value));
    }

    public static List<String> toUnixTimestamp(List<LocalDateTime> values) {
        if (values == null) {
            return null;
        }
        ArrayList<String> valuesAsString = new ArrayList<String>();
        for (LocalDateTime value : values) {
            valuesAsString.add(LocalDateTimeHelper.toUnixTimestamp(value));
        }
        return valuesAsString;
    }

    public static Map<String, String> toUnixTimestamp(Map<String, LocalDateTime> values) {
        if (values == null) {
            return null;
        }
        HashMap<String, String> valuesAsString = new HashMap<String, String>();
        for (Map.Entry<String, LocalDateTime> value : values.entrySet()) {
            valuesAsString.put(value.getKey(), LocalDateTimeHelper.toUnixTimestamp(value.getValue()));
        }
        return valuesAsString;
    }

    public static List<Map<String, String>> toArrayOfMapOfUnixTimestamp(List<Map<String, LocalDateTime>> values) {
        if (values == null) {
            return null;
        }
        ArrayList<Map<String, String>> valuesAsString = new ArrayList<Map<String, String>>();
        for (Map<String, LocalDateTime> value : values) {
            valuesAsString.add(LocalDateTimeHelper.toUnixTimestamp(value));
        }
        return valuesAsString;
    }

    public static Long toUnixTimestampLong(LocalDateTime value) {
        return value == null ? null : Long.valueOf(LocalDateTime.ofInstant(value.atZone(ZoneId.systemDefault()).toInstant(), ZoneOffset.UTC).toEpochSecond(ZoneOffset.UTC));
    }

    public static List<Long> toUnixTimestampLong(List<LocalDateTime> values) {
        if (values == null) {
            return null;
        }
        ArrayList<Long> valuesAsLong = new ArrayList<Long>();
        for (LocalDateTime value : values) {
            valuesAsLong.add(LocalDateTimeHelper.toUnixTimestampLong(value));
        }
        return valuesAsLong;
    }

    public static Map<String, Long> toUnixTimestampLong(Map<String, LocalDateTime> values) {
        if (values == null) {
            return null;
        }
        HashMap<String, Long> valuesAsLong = new HashMap<String, Long>();
        for (Map.Entry<String, LocalDateTime> value : values.entrySet()) {
            valuesAsLong.put(value.getKey(), LocalDateTimeHelper.toUnixTimestampLong(value.getValue()));
        }
        return valuesAsLong;
    }

    public static List<Map<String, Long>> toArrayOfMapOfUnixTimestampLong(List<Map<String, LocalDateTime>> values) {
        if (values == null) {
            return null;
        }
        ArrayList<Map<String, Long>> valuesAsLong = new ArrayList<Map<String, Long>>();
        for (Map<String, LocalDateTime> value : values) {
            valuesAsLong.add(LocalDateTimeHelper.toUnixTimestampLong(value));
        }
        return valuesAsLong;
    }

    public static LocalDateTime fromRfc1123DateTime(String date) {
        return LocalDateTime.parse(date, RFC1123_DATE_TIME_FORMATTER);
    }

    public static String toRfc1123DateTime(LocalDateTime value) {
        return value == null ? null : RFC1123_DATE_TIME_FORMATTER.format(value.atZone(ZoneId.of("GMT")));
    }

    public static List<String> toRfc1123DateTime(List<LocalDateTime> values) {
        if (values == null) {
            return null;
        }
        ArrayList<String> valuesAsString = new ArrayList<String>();
        for (LocalDateTime value : values) {
            valuesAsString.add(LocalDateTimeHelper.toRfc1123DateTime(value));
        }
        return valuesAsString;
    }

    public static Map<String, String> toRfc1123DateTime(Map<String, LocalDateTime> values) {
        if (values == null) {
            return null;
        }
        HashMap<String, String> valuesAsString = new HashMap<String, String>();
        for (Map.Entry<String, LocalDateTime> value : values.entrySet()) {
            valuesAsString.put(value.getKey(), LocalDateTimeHelper.toRfc1123DateTime(value.getValue()));
        }
        return valuesAsString;
    }

    public static List<Map<String, String>> toArrayOfMapOfRfc1123DateTime(List<Map<String, LocalDateTime>> values) {
        if (values == null) {
            return null;
        }
        ArrayList<Map<String, String>> valuesAsString = new ArrayList<Map<String, String>>();
        for (Map<String, LocalDateTime> value : values) {
            valuesAsString.add(LocalDateTimeHelper.toRfc1123DateTime(value));
        }
        return valuesAsString;
    }

    public static LocalDateTime fromRfc8601DateTime(String date) {
        Pattern pattern = Pattern.compile("(Z|([+-])(\\d{2}:\\d{2}))$");
        Matcher patternMatcher = pattern.matcher(date);
        if (patternMatcher.find()) {
            OffsetDateTime parsed = OffsetDateTime.parse(date, DateTimeFormatter.ISO_DATE_TIME);
            return LocalDateTime.from(parsed.withOffsetSameInstant(ZoneOffset.UTC));
        }
        return LocalDateTime.parse(date, DateTimeFormatter.ISO_DATE_TIME);
    }

    public static String toRfc8601DateTime(LocalDateTime value) {
        return value == null ? null : value.toString() + "Z";
    }

    public static List<String> toRfc8601DateTime(List<LocalDateTime> values) {
        if (values == null) {
            return null;
        }
        ArrayList<String> valuesAsString = new ArrayList<String>();
        for (LocalDateTime value : values) {
            valuesAsString.add(LocalDateTimeHelper.toRfc8601DateTime(value));
        }
        return valuesAsString;
    }

    public static Map<String, String> toRfc8601DateTime(Map<String, LocalDateTime> values) {
        if (values == null) {
            return null;
        }
        HashMap<String, String> valuesAsString = new HashMap<String, String>();
        for (Map.Entry<String, LocalDateTime> value : values.entrySet()) {
            valuesAsString.put(value.getKey(), LocalDateTimeHelper.toRfc8601DateTime(value.getValue()));
        }
        return valuesAsString;
    }

    public static List<Map<String, String>> toArrayOfMapOfRfc8601DateTime(List<Map<String, LocalDateTime>> values) {
        if (values == null) {
            return null;
        }
        ArrayList<Map<String, String>> valuesAsString = new ArrayList<Map<String, String>>();
        for (Map<String, LocalDateTime> value : values) {
            valuesAsString.add(LocalDateTimeHelper.toRfc8601DateTime(value));
        }
        return valuesAsString;
    }

    public static class UnixTimestampAdapter
    extends XmlAdapter<String, LocalDateTime> {
        public String marshal(LocalDateTime dateTime) {
            return LocalDateTimeHelper.toUnixTimestamp(dateTime);
        }

        public LocalDateTime unmarshal(String dateTime) {
            return LocalDateTimeHelper.fromUnixTimestamp(dateTime);
        }
    }

    public static class Rfc8601DateTimeAdapter
    extends XmlAdapter<String, LocalDateTime> {
        public String marshal(LocalDateTime dateTime) {
            return LocalDateTimeHelper.toRfc8601DateTime(dateTime);
        }

        public LocalDateTime unmarshal(String dateTime) {
            return LocalDateTimeHelper.fromRfc8601DateTime(dateTime);
        }
    }

    public static class Rfc1123DateTimeAdapter
    extends XmlAdapter<String, LocalDateTime> {
        public String marshal(LocalDateTime dateTime) {
            return LocalDateTimeHelper.toRfc1123DateTime(dateTime);
        }

        public LocalDateTime unmarshal(String dateTime) {
            return LocalDateTimeHelper.fromRfc1123DateTime(dateTime);
        }
    }

    public static class Rfc8601DateTimeSerializer
    extends JsonSerializer<LocalDateTime> {
        public void serialize(LocalDateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(LocalDateTimeHelper.toRfc8601DateTime(value));
        }
    }

    public static class Rfc8601DateTimeDeserializer
    extends JsonDeserializer<LocalDateTime> {
        public LocalDateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return LocalDateTimeHelper.fromRfc8601DateTime(jp.getValueAsString());
        }
    }

    public static class Rfc1123DateTimeSerializer
    extends JsonSerializer<LocalDateTime> {
        public void serialize(LocalDateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(LocalDateTimeHelper.toRfc1123DateTime(value));
        }
    }

    public static class Rfc1123DateTimeDeserializer
    extends JsonDeserializer<LocalDateTime> {
        public LocalDateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return LocalDateTimeHelper.fromRfc1123DateTime(jp.getValueAsString());
        }
    }

    public static class UnixTimestampSerializer
    extends JsonSerializer<LocalDateTime> {
        public void serialize(LocalDateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)LocalDateTimeHelper.toUnixTimestampLong(value));
        }
    }

    public static class UnixTimestampDeserializer
    extends JsonDeserializer<LocalDateTime> {
        public LocalDateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return LocalDateTimeHelper.fromUnixTimestamp(jp.getValueAsString());
        }
    }
}

