/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.types.pagination;

import io.apimatic.core.HttpRequest;
import io.apimatic.core.types.pagination.PageWrapper;
import io.apimatic.core.types.pagination.PaginatedData;
import io.apimatic.core.types.pagination.PaginationStrategy;
import io.apimatic.core.utilities.CoreHelper;
import io.apimatic.coreinterfaces.http.response.Response;

public class LinkPagination
implements PaginationStrategy {
    private final String next;
    private String currentRequestLink;

    public LinkPagination(String next) {
        this.next = next;
    }

    @Override
    public HttpRequest.Builder apply(PaginatedData<?, ?, ?, ?> paginatedData) {
        Response response = paginatedData.getResponse();
        this.currentRequestLink = null;
        if (response == null) {
            return paginatedData.getRequestBuilder();
        }
        String linkValue = CoreHelper.resolveResponsePointer(this.next, response);
        if (linkValue == null) {
            return null;
        }
        this.currentRequestLink = linkValue;
        return paginatedData.getRequestBuilder().queryParam(CoreHelper.getQueryParameters(linkValue));
    }

    @Override
    public void addMetaData(PageWrapper<?, ?> page) {
        page.setNextLinkInput(this.currentRequestLink);
    }
}

