/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.types.pagination;

import io.apimatic.core.HttpRequest;
import io.apimatic.core.types.pagination.PageWrapper;
import io.apimatic.core.types.pagination.PaginatedData;
import io.apimatic.core.types.pagination.PaginationStrategy;
import io.apimatic.core.utilities.CoreHelper;
import io.apimatic.coreinterfaces.http.response.Response;
import java.util.concurrent.atomic.AtomicBoolean;

public class CursorPagination
implements PaginationStrategy {
    private final String output;
    private final String input;
    private String currentRequestCursor;

    public CursorPagination(String output, String input) {
        this.output = output;
        this.input = input;
    }

    @Override
    public HttpRequest.Builder apply(PaginatedData<?, ?, ?, ?> paginatedData) {
        Response response = paginatedData.getResponse();
        HttpRequest.Builder reqBuilder = paginatedData.getRequestBuilder();
        AtomicBoolean isUpdated = new AtomicBoolean(false);
        this.currentRequestCursor = null;
        reqBuilder.updateParameterByJsonPointer(this.input, old -> {
            if (response == null) {
                this.currentRequestCursor = (String)old;
                isUpdated.set(true);
                return old;
            }
            String cursorValue = CoreHelper.resolveResponsePointer(this.output, response);
            if (cursorValue == null) {
                return old;
            }
            this.currentRequestCursor = cursorValue;
            isUpdated.set(true);
            return cursorValue;
        });
        if (!isUpdated.get() && response == null) {
            return reqBuilder;
        }
        return isUpdated.get() ? reqBuilder : null;
    }

    @Override
    public void addMetaData(PageWrapper<?, ?> page) {
        page.setCursorInput(this.currentRequestCursor);
    }
}

